/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.stax;

import java.io.FileReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReaderToWriter {
    private XMLStreamWriter writer;

    public ReaderToWriter() {
    }

    public ReaderToWriter(XMLStreamWriter xmlw) {
        this.writer = xmlw;
    }

    public void setStreamWriter(XMLStreamWriter xmlw) {
        this.writer = xmlw;
    }

    public void writeAll(XMLStreamReader xmlr) throws XMLStreamException {
        while (xmlr.hasNext()) {
            this.write(xmlr);
            xmlr.next();
        }
        this.writer.flush();
    }

    public void write(XMLStreamReader xmlr) throws XMLStreamException {
        switch (xmlr.getEventType()) {
            case 1: {
                String localName = xmlr.getLocalName();
                String namespaceURI = xmlr.getNamespaceURI();
                if (namespaceURI != null && namespaceURI.length() > 0) {
                    String prefix = xmlr.getPrefix();
                    if (prefix != null) {
                        this.writer.writeStartElement(prefix, localName, namespaceURI);
                    } else {
                        this.writer.writeStartElement(namespaceURI, localName);
                    }
                } else {
                    this.writer.writeStartElement(localName);
                }
                int i = 0;
                while (i < xmlr.getNamespaceCount()) {
                    this.writer.writeNamespace(xmlr.getNamespacePrefix(i), xmlr.getNamespaceURI(i));
                    ++i;
                }
                int i2 = 0;
                while (i2 < xmlr.getAttributeCount()) {
                    String attUri = xmlr.getAttributeNamespace(i2);
                    if (attUri != null) {
                        this.writer.writeAttribute(attUri, xmlr.getAttributeLocalName(i2), xmlr.getAttributeValue(i2));
                    } else {
                        this.writer.writeAttribute(xmlr.getAttributeLocalName(i2), xmlr.getAttributeValue(i2));
                    }
                    ++i2;
                }
                break;
            }
            case 2: {
                this.writer.writeEndElement();
                break;
            }
            case 4: 
            case 6: {
                this.writer.writeCharacters(xmlr.getTextCharacters(), xmlr.getTextStart(), xmlr.getTextLength());
                break;
            }
            case 3: {
                this.writer.writeProcessingInstruction(xmlr.getPITarget(), xmlr.getPIData());
                break;
            }
            case 12: {
                this.writer.writeCData(xmlr.getText());
                break;
            }
            case 5: {
                this.writer.writeComment(xmlr.getText());
                break;
            }
            case 9: {
                this.writer.writeEntityRef(xmlr.getLocalName());
                break;
            }
            case 7: {
                String encoding = xmlr.getCharacterEncodingScheme();
                String version = xmlr.getVersion();
                if (encoding != null && version != null) {
                    this.writer.writeStartDocument(encoding, version);
                    break;
                }
                if (version == null) break;
                this.writer.writeStartDocument(xmlr.getVersion());
                break;
            }
            case 8: {
                this.writer.writeEndDocument();
                break;
            }
            case 11: {
                this.writer.writeDTD(xmlr.getText());
            }
        }
    }

    public static void main(String[] args) throws Exception {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        XMLOutputFactory xmlof = XMLOutputFactory.newInstance();
        XMLStreamReader xmlr = xmlif.createXMLStreamReader(new FileReader(args[0]));
        XMLStreamWriter xmlw = xmlof.createXMLStreamWriter(System.out);
        ReaderToWriter rtow = new ReaderToWriter(xmlw);
        while (xmlr.hasNext()) {
            rtow.write(xmlr);
            xmlr.next();
        }
        xmlw.flush();
    }
}

