/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.BufferedInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.InputSource;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.stream.XMLEventReader;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.NullEvent;

public class XMLEventPlayer
extends XMLInputStreamBase {
    protected XMLEventReader reader;

    public XMLEventPlayer() {
        this.elementQ = new CircularQueue(8);
    }

    public void open(InputSource inputSource) throws XMLStreamException {
        try {
            this.reader = new XMLEventReader(this.resolve(inputSource));
            this.open = true;
            this.parseSome();
            if (inputSource.getByteStream() != null) {
                this.checkEncoding(inputSource.getByteStream());
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + iOException.getMessage());
        }
    }

    public void open(InputStream inputStream) throws XMLStreamException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(4096);
            this.reader = new XMLEventReader(new InputStreamReader(bufferedInputStream));
            this.open = true;
            this.parseSome();
            try {
                XMLEvent xMLEvent = (XMLEvent)this.elementQ.peek();
                if (xMLEvent.isStartDocument() && !((StartDocument)xMLEvent).getCharacterEncodingScheme().equals("")) {
                    bufferedInputStream.reset();
                    this.checkEncoding(bufferedInputStream);
                }
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + iOException.getMessage());
        }
    }

    public void open(Reader reader) throws XMLStreamException {
        try {
            this.reader = new XMLEventReader(reader);
            this.open = true;
            this.parseSome();
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + iOException.getMessage());
        }
    }

    protected void checkEncoding(InputStream inputStream) throws XMLStreamException {
        XMLEvent xMLEvent = (XMLEvent)this.elementQ.remove();
        if (xMLEvent.isStartDocument()) {
            StartDocument startDocument = (StartDocument)xMLEvent;
            try {
                this.reader = new XMLEventReader(new InputStreamReader(inputStream, startDocument.getCharacterEncodingScheme()));
                this.open = true;
                this.parseSome();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLStreamException((Throwable)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new XMLStreamException((Throwable)iOException);
            }
        }
    }

    protected Reader resolve(InputSource inputSource) throws XMLStreamException {
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return new InputStreamReader(inputSource.getByteStream());
        }
        throw new XMLStreamException("XMLEventPlayer needs a stream or a reader as input");
    }

    public boolean parseSome() throws XMLStreamException {
        try {
            if (!this.reader.hasNext()) {
                return false;
            }
            XMLEvent xMLEvent = this.reader.readElement();
            this.add(xMLEvent);
            return true;
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to read from the reader " + iOException.getMessage());
        }
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        if (!this.elementQ.isEmpty()) {
            return true;
        }
        try {
            if (this.reader != null && this.reader.hasNext()) {
                return true;
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to read from the reader " + iOException.getMessage());
        }
        return false;
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        try {
            if (this.reader != null && this.reader.hasNext() && this.parseSome()) {
                return (XMLEvent)this.elementQ.peek();
            }
            return new NullEvent();
        }
        catch (IOException iOException) {
            throw new XMLStreamException("Unable to read from the reader " + iOException.getMessage());
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLEventPlayer xMLEventPlayer = new XMLEventPlayer();
        xMLEventPlayer.open(new FileReader(stringArray[0]));
        while (xMLEventPlayer.hasNext()) {
            XMLEvent xMLEvent = xMLEventPlayer.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
    }
}

