/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.stream.CanonicalUtils;
import weblogic.xml.babel.stream.ScopeManager;
import weblogic.xml.babel.stream.XMLInputStreamBase;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.StartElementEvent;

public class CanonicalWriter
extends XMLWriter {
    private boolean writeComments = true;
    private ScopeManager namespaces = new ScopeManager();
    private boolean beforeDocumentElement;
    private Map externalNS = null;
    public static String XML_PREFIX_NS = "http://www.w3.org/XML/1998/namespace";

    public CanonicalWriter(Writer writer) {
        this.writeAll = false;
        this.writeHeader = false;
        this.writer = writer;
        this.beforeDocumentElement = true;
    }

    public CanonicalWriter(Writer writer, Map map) {
        this(writer);
        this.externalNS = map;
    }

    public void setWriteComments(boolean bl) {
        this.writeComments = bl;
    }

    private void checkLevel() throws XMLStreamException {
        if (this.elementLevel == 0) {
            this.EOL();
        }
    }

    private void EOL() throws XMLStreamException {
        this.write('\n');
    }

    protected void writeCharacters(String string, boolean bl) throws XMLStreamException {
        String string2 = CanonicalUtils.normalizeCharacters(string, bl);
        if (string2 != null) {
            this.write(string2);
        }
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
    }

    private String getPrefix(String string) {
        if (string.equals("")) {
            return "xmlns";
        }
        return string;
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
    }

    public ScopeManager getScopedNamespaces() {
        return this.namespaces;
    }

    public Map getExternalNamespaces() {
        if (this.externalNS != null) {
            return this.externalNS;
        }
        return Collections.EMPTY_MAP;
    }

    public void writeNamespaces(AttributeIterator attributeIterator) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            this.namespaces.checkPrefixMap(attribute.getName().getLocalName(), attribute.getValue());
            if (!this.namespaces.needToWriteNS(attribute.getName().getLocalName())) continue;
            this.write(" ");
            this.write(attribute);
            this.namespaces.wroteNS(attribute.getName().getLocalName());
        }
    }

    public void incrementLevel() {
        this.beforeDocumentElement = false;
        ++this.elementLevel;
    }

    public void write(StartElement startElement) throws XMLStreamException {
        this.incrementLevel();
        this.namespaces.openScope();
        this.write('<');
        this.write(startElement.getName());
        if (this.externalNS != null) {
            startElement = this.declareParentNamespaces(startElement, this.externalNS);
            this.externalNS = null;
        }
        this.writeNamespaces(CanonicalUtils.sortNamespaces(startElement.getNamespaces()));
        this.write(CanonicalUtils.sortAttributes(startElement.getAttributes()));
        this.write('>');
    }

    public void write(EndElement endElement) throws XMLStreamException {
        this.namespaces.closeScope();
        super.write(endElement);
    }

    public void write(Comment comment) throws XMLStreamException {
        if (!this.writeComments) {
            return;
        }
        if (!this.beforeDocumentElement) {
            this.checkLevel();
            super.write(comment);
        } else {
            super.write(comment);
            this.checkLevel();
        }
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
        if (!this.beforeDocumentElement) {
            this.checkLevel();
            super.write(processingInstruction);
        } else {
            super.write(processingInstruction);
            this.checkLevel();
        }
    }

    public void setWriteHeader(boolean bl) {
        this.writeHeader = false;
    }

    public void write(Space space) throws XMLStreamException {
        if (this.elementLevel > 0 && space.hasContent()) {
            this.write(space.getContent());
        }
    }

    public StartElement declareParentNamespaces(StartElement startElement, Map map) {
        Object object;
        StartElementEvent startElementEvent = new StartElementEvent(startElement);
        HashSet<String> hashSet = new HashSet<String>();
        AttributeIterator attributeIterator = startElementEvent.getNamespaces();
        while (attributeIterator.hasNext()) {
            object = attributeIterator.next();
            hashSet.add(object.getValue());
        }
        if (map != null) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Attribute attribute;
                Map.Entry entry = (Map.Entry)object.next();
                String string = (String)entry.getValue();
                if (hashSet.contains(string) || string.equals(XML_PREFIX_NS)) continue;
                String string2 = (String)entry.getKey();
                if (string2.startsWith("xml:")) {
                    attribute = ElementFactory.createAttribute((String)string2, (String)string);
                    startElementEvent.addAttribute(attribute);
                    continue;
                }
                if (string2.equals("")) {
                    string2 = null;
                }
                attribute = ElementFactory.createNamespaceAttribute((String)string2, (String)string);
                hashSet.add(string);
                startElementEvent.addNamespace(attribute);
            }
        }
        return startElementEvent;
    }

    public static void main(String[] stringArray) throws Exception {
        CanonicalWriter canonicalWriter = new CanonicalWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("out.xml"), "utf-8"));
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(SAXElementFactory.createInputSource(stringArray[0]));
        XMLOutputStreamBase xMLOutputStreamBase = new XMLOutputStreamBase(canonicalWriter);
        xMLOutputStreamBase.add(xMLInputStreamBase);
        xMLOutputStreamBase.flush();
    }
}

