/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Space;
import weblogic.xml.babel.scanner.SystemLiteral;

final class ExternalID {
    private ScannerState state;
    private SystemLiteral systemLiteral;
    private SystemLiteral pubidLiteral;
    private Space space;

    ExternalID(ScannerState scannerState) {
        this.state = scannerState;
        this.systemLiteral = new SystemLiteral(scannerState);
        this.pubidLiteral = new SystemLiteral(scannerState);
        this.space = new Space(scannerState);
    }

    public boolean read() throws IOException, ScannerException {
        switch (this.state.currentChar) {
            case 'S': {
                this.state.expect("SYSTEM");
                this.state.pushToken(this.state.tokenFactory.createToken(25));
                this.space.read();
                this.systemLiteral.read();
                break;
            }
            case 'P': {
                this.state.expect("PUBLIC");
                this.state.pushToken(this.state.tokenFactory.createToken(26));
                this.space.read();
                this.pubidLiteral.read();
                this.space.read();
                if (this.state.currentChar != '\"' && this.state.currentChar != '\'') break;
                this.systemLiteral.read();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

