/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.dtd.AttributeDefault;
import weblogic.xml.babel.dtd.AttributeType;
import weblogic.xml.babel.dtd.Cdata;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.dtd.Entities;
import weblogic.xml.babel.dtd.Entity;
import weblogic.xml.babel.dtd.Enumeration;
import weblogic.xml.babel.dtd.Id;
import weblogic.xml.babel.dtd.Idref;
import weblogic.xml.babel.dtd.Idrefs;
import weblogic.xml.babel.dtd.Name;
import weblogic.xml.babel.dtd.Nmtoken;
import weblogic.xml.babel.dtd.Nmtokens;
import weblogic.xml.babel.dtd.Notation;
import weblogic.xml.babel.scanner.ScannerException;

public class AttributeDefinition
extends Declaration {
    private Name name;
    private Space space;
    private AttributeType attType;
    private AttributeDefault attDefault;

    public AttributeDefinition() {
        this.init();
    }

    public void init() {
        super.init();
        this.name = new Name();
        this.space = new Space();
        this.attDefault = new AttributeDefault();
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        this.space.parse(baseParser);
        this.name.parse(baseParser);
        this.space.parse(baseParser);
        this.parseAttributeType(baseParser);
        this.attDefault.parse(baseParser);
    }

    public boolean hasDefault() {
        return this.attDefault.hasDefault();
    }

    public void parseAttributeType(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        switch (baseParser.getCurrentToken().tokenType) {
            case 11: {
                this.attType = new Cdata();
                this.attType.parse(baseParser);
                break;
            }
            case 41: {
                this.attType = new Id();
                this.attType.parse(baseParser);
                break;
            }
            case 42: {
                this.attType = new Idref();
                this.attType.parse(baseParser);
                break;
            }
            case 43: {
                this.attType = new Idrefs();
                this.attType.parse(baseParser);
                break;
            }
            case 44: {
                this.attType = new Entity();
                this.attType.parse(baseParser);
                break;
            }
            case 45: {
                this.attType = new Entities();
                this.attType.parse(baseParser);
                break;
            }
            case 46: {
                this.attType = new Nmtoken();
                this.attType.parse(baseParser);
                break;
            }
            case 47: {
                this.attType = new Nmtokens();
                this.attType.parse(baseParser);
                break;
            }
            case 48: {
                this.attType = new Notation();
                this.attType.parse(baseParser);
                break;
            }
            case 30: {
                this.attType = new Enumeration();
                this.attType.parse(baseParser);
                break;
            }
            default: {
                throw new ParseException("An attribute declaration must include the attribute type which is CDATA,ID,IDREF,IDREFS,ENTITY,ENTITIES,NMTOKEN,NMTOKENS or an enumerated type", baseParser.getLine(), baseParser.getCurrentToken());
            }
        }
    }

    public String toString() {
        return this.name + " " + this.attType + " " + this.attDefault;
    }

    public int getType() {
        return this.attType.getType();
    }

    public Attribute createDefaultAttribute() {
        Attribute attribute = new Attribute();
        attribute.init();
        attribute.setLocalName(this.name.getRawName());
        attribute.setValue(this.attDefault.getValue());
        attribute.setType(this.getType());
        return attribute;
    }

    public String getRawName() {
        return this.name.getRawName();
    }
}

