/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.client.ClientTxnPortableHook;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.xa.TransactionAccessor;
import java.io.IOException;
import java.security.Permission;

public abstract class BaseXATransactionRequest
extends CallableClientRequest {
    protected String txnId;

    public BaseXATransactionRequest() {
    }

    public BaseXATransactionRequest(String txnId) {
        this.txnId = txnId;
    }

    protected Transaction getTransaction() {
        TransactionContext transactionContext = this.endpoint.getTransactionContext(this.txnId);
        if (transactionContext == null) {
            throw new TransactionException("No transaction context with given transactionId: " + this.txnId);
        }
        return TransactionAccessor.getTransaction(transactionContext);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("tId", this.txnId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.txnId = reader.readUTF("tId");
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    public int getFactoryId() {
        return ClientTxnPortableHook.F_ID;
    }

    @Override
    public Permission getRequiredPermission() {
        return new TransactionPermission();
    }
}

