/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import net.kano.joscar.rvproto.ft.FileTransferChecksum;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Checksummer;

public class ChecksummerImpl
implements Checksummer {
    private volatile long position = 0L;
    private boolean summed = false;
    private final FileChannel channel;
    private final long end;

    public ChecksummerImpl(FileChannel channel, long length) {
        this.channel = channel;
        this.end = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long compute() throws IOException, IllegalStateException {
        long sum;
        ChecksummerImpl checksummerImpl;
        ChecksummerImpl checksummerImpl2 = this;
        synchronized (checksummerImpl2) {
            if (this.summed) {
                throw new IllegalStateException("already summing or summed");
            }
            this.summed = true;
        }
        long origOffset = -1L;
        try {
            checksummerImpl = this;
            synchronized (checksummerImpl) {
                origOffset = this.channel.position();
                this.channel.position(0L);
            }
            FileTransferChecksum summer = new FileTransferChecksum();
            ByteBuffer buffer = ByteBuffer.allocate(1024);
            long remaining = this.end;
            while (remaining > 0L) {
                buffer.rewind();
                buffer.limit((int)Math.min(remaining, (long)buffer.capacity()));
                int count = this.channel.read(buffer);
                if (count == -1) break;
                buffer.flip();
                summer.update(buffer.array(), buffer.arrayOffset(), buffer.limit());
                long newPos = this.end - (remaining -= (long)buffer.limit());
                this.setPosition(newPos);
            }
            if (remaining > 0L) {
                throw new IOException("could not get checksum for entire file; " + remaining + " failed of " + this.end);
            }
            sum = summer.getValue();
        }
        finally {
            checksummerImpl = this;
            synchronized (checksummerImpl) {
                this.setPosition(this.end);
                if (origOffset != -1L) {
                    this.channel.position(origOffset);
                }
            }
        }
        return sum;
    }

    private void setPosition(long newPos) {
        this.position = newPos;
    }

    public long getStartPosition() {
        return 0L;
    }

    public long getPosition() {
        return this.position;
    }

    public long getLength() {
        return this.end;
    }
}

