/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.mortbay.jetty.servlet.AbstractSessionManager;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class HashSessionManager
extends AbstractSessionManager {
    private int _scavengePeriodMs = 30000;
    private Thread _scavenger = null;
    protected Map _sessions;

    public void doStart() throws Exception {
        this._sessions = new HashMap();
        super.doStart();
        this.getSessionHandler().getServer().getThreadPool().dispatch((Runnable)new SessionScavenger());
    }

    public void doStop() throws Exception {
        super.doStop();
        this._sessions.clear();
        this._sessions = null;
        Thread scavenger = this._scavenger;
        this._scavenger = null;
        if (scavenger != null) {
            scavenger.interrupt();
        }
    }

    public int getScavengePeriod() {
        return this._scavengePeriodMs / 1000;
    }

    public Map getSessionMap() {
        return Collections.unmodifiableMap(this._sessions);
    }

    public int getSessions() {
        return this._sessions.size();
    }

    public void setMaxInactiveInterval(int seconds) {
        super.setMaxInactiveInterval(seconds);
        if (this._dftMaxIdleSecs > 0 && this._scavengePeriodMs > this._dftMaxIdleSecs * 1000) {
            this.setScavengePeriod((this._dftMaxIdleSecs + 9) / 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScavengePeriod(int seconds) {
        if (seconds == 0) {
            seconds = 60;
        }
        int old_period = this._scavengePeriodMs;
        int period = seconds * 1000;
        if (period > 60000) {
            period = 60000;
        }
        if (period < 1000) {
            period = 1000;
        }
        if (period != old_period) {
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                this._scavengePeriodMs = period;
                if (this._scavenger != null) {
                    this._scavenger.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scavenge() {
        Thread thread = Thread.currentThread();
        ClassLoader old_loader = thread.getContextClassLoader();
        try {
            if (this._loader != null) {
                thread.setContextClassLoader(this._loader);
            }
            long now = System.currentTimeMillis();
            Object stale = null;
            HashSessionManager hashSessionManager = this;
            synchronized (hashSessionManager) {
                Iterator i = this._sessions.values().iterator();
                while (i.hasNext()) {
                    Session session = (Session)i.next();
                    long idleTime = session._maxIdleMs;
                    if (idleTime <= 0L || session._accessed + idleTime >= now) continue;
                    stale = LazyList.add(stale, (Object)session);
                }
            }
            int i = LazyList.size(stale);
            while (i-- > 0) {
                Session session = (Session)LazyList.get(stale, (int)i);
                long idleTime = session._maxIdleMs;
                if (idleTime <= 0L || session._accessed + idleTime >= System.currentTimeMillis()) continue;
                session.invalidate();
                int nbsess = this._sessions.size();
                if (nbsess >= this._minSessions) continue;
                this._minSessions = nbsess;
            }
        }
        finally {
            thread.setContextClassLoader(old_loader);
        }
    }

    protected void addSession(AbstractSessionManager.Session session) {
        this._sessions.put(session.getClusterId(), session);
    }

    protected AbstractSessionManager.Session getSession(String idInCluster) {
        return (Session)this._sessions.get(idInCluster);
    }

    protected void invalidateSessions() {
        ArrayList sessions = new ArrayList(this._sessions.values());
        Iterator i = sessions.iterator();
        while (i.hasNext()) {
            Session session = (Session)i.next();
            session.invalidate();
        }
        this._sessions.clear();
    }

    protected AbstractSessionManager.Session newSession(HttpServletRequest request) {
        return new Session(request);
    }

    protected void removeSession(String idInCluster) {
        this._sessions.remove(idInCluster);
    }

    class SessionScavenger
    implements Runnable {
        SessionScavenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSessionManager.this._scavenger = Thread.currentThread();
            String name = Thread.currentThread().getName();
            if (HashSessionManager.this._context != null) {
                Thread.currentThread().setName(name + " - Invalidator - " + HashSessionManager.this._context.getContextPath());
            }
            int period = -1;
            try {
                do {
                    try {
                        if (period != HashSessionManager.this._scavengePeriodMs) {
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)("Session scavenger period = " + HashSessionManager.this._scavengePeriodMs / 1000 + "s"));
                            }
                            period = HashSessionManager.this._scavengePeriodMs;
                        }
                        Thread.sleep(period > 1000 ? (long)period : 1000L);
                        HashSessionManager.this.scavenge();
                    }
                    catch (InterruptedException ex) {
                    }
                    catch (Error e) {
                        Log.warn((String)"EXCEPTION ", (Throwable)e);
                    }
                    catch (Exception e) {
                        Log.warn((String)"EXCEPTION ", (Throwable)e);
                    }
                } while (HashSessionManager.this.isStarted());
            }
            finally {
                HashSessionManager.this._scavenger = null;
                String exit = "Session scavenger exited";
                if (HashSessionManager.this.isStarted()) {
                    Log.warn((String)exit);
                } else {
                    Log.debug((String)exit);
                }
                Thread.currentThread().setName(name);
            }
        }
    }

    protected class Session
    extends AbstractSessionManager.Session {
        private static final long serialVersionUID = -2134521374206116367L;

        protected Session(HttpServletRequest request) {
            super(request);
        }

        public void setMaxInactiveInterval(int secs) {
            super.setMaxInactiveInterval(secs);
            if (this._maxIdleMs > 0L && this._maxIdleMs / 10L < (long)HashSessionManager.this._scavengePeriodMs) {
                HashSessionManager.this.setScavengePeriod((secs + 9) / 10);
            }
        }

        protected Map newAttributeMap() {
            return new HashMap(3);
        }
    }
}

