/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.util.StringUtil;

public class MimeTypes {
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML_8859_1 = "text/html; charset=iso-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain; charset=iso-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml; charset=iso-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html; charset=utf-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain; charset=utf-8";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=utf-8";
    private static final int FORM_ENCODED_ORDINAL = 1;
    private static final int MESSAGE_HTTP_ORDINAL = 2;
    private static final int MULTIPART_BYTERANGES_ORDINAL = 3;
    private static final int TEXT_HTML_ORDINAL = 4;
    private static final int TEXT_PLAIN_ORDINAL = 5;
    private static final int TEXT_XML_ORDINAL = 6;
    private static final int TEXT_HTML_8859_1_ORDINAL = 7;
    private static final int TEXT_PLAIN_8859_1_ORDINAL = 8;
    private static final int TEXT_XML_8859_1_ORDINAL = 9;
    private static final int TEXT_HTML_UTF_8_ORDINAL = 10;
    private static final int TEXT_PLAIN_UTF_8_ORDINAL = 11;
    private static final int TEXT_XML_UTF_8_ORDINAL = 12;
    private static int __index = 13;
    public static final BufferCache CACHE = new BufferCache();
    public static final BufferCache.CachedBuffer FORM_ENCODED_BUFFER = CACHE.add("application/x-www-form-urlencoded", 1);
    public static final BufferCache.CachedBuffer MESSAGE_HTTP_BUFFER = CACHE.add("message/http", 2);
    public static final BufferCache.CachedBuffer MULTIPART_BYTERANGES_BUFFER = CACHE.add("multipart/byteranges", 3);
    public static final BufferCache.CachedBuffer TEXT_HTML_BUFFER = CACHE.add("text/html", 4);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_BUFFER = CACHE.add("text/plain", 5);
    public static final BufferCache.CachedBuffer TEXT_XML_BUFFER = CACHE.add("text/xml", 6);
    public static final BufferCache.CachedBuffer TEXT_HTML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/html; charset=iso-8859-1", 7);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_8859_1_BUFFER = new BufferCache.CachedBuffer("text/plain; charset=iso-8859-1", 8);
    public static final BufferCache.CachedBuffer TEXT_XML_8859_1_BUFFER = new BufferCache.CachedBuffer("text/xml; charset=iso-8859-1", 9);
    public static final BufferCache.CachedBuffer TEXT_HTML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/html; charset=utf-8", 10);
    public static final BufferCache.CachedBuffer TEXT_PLAIN_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/plain; charset=utf-8", 11);
    public static final BufferCache.CachedBuffer TEXT_XML_UTF_8_BUFFER = new BufferCache.CachedBuffer("text/xml; charset=utf-8", 12);
    private static final Map __dftMimeMap = new HashMap();
    private static final Map __encodings = new HashMap();
    private Map _mimeMap;

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map mimeMap) {
        if (mimeMap == null) {
            this._mimeMap = null;
            return;
        }
        HashMap m = new HashMap();
        Iterator i = mimeMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            m.put(entry.getKey(), MimeTypes.normalizeMimeType(entry.getValue().toString()));
        }
        this._mimeMap = m;
    }

    public Buffer getMimeByExtension(String filename) {
        Buffer type = null;
        if (filename != null) {
            int i = -1;
            while (type == null && (i = filename.indexOf(".", i + 1)) >= 0 && i < filename.length()) {
                String ext = StringUtil.asciiToLowerCase((String)filename.substring(i + 1));
                if (this._mimeMap != null) {
                    type = (Buffer)this._mimeMap.get(ext);
                }
                if (type != null) continue;
                type = (Buffer)__dftMimeMap.get(ext);
            }
        }
        if (type == null) {
            if (this._mimeMap != null) {
                type = (Buffer)this._mimeMap.get("*");
            }
            if (type == null) {
                type = (Buffer)__dftMimeMap.get("*");
            }
        }
        return type;
    }

    public void addMimeMapping(String extension, String type) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase((String)extension), MimeTypes.normalizeMimeType(type));
    }

    private static synchronized Buffer normalizeMimeType(String type) {
        BufferCache.CachedBuffer b = CACHE.get(type);
        if (b == null) {
            b = CACHE.add(type, __index++);
        }
        return b;
    }

    public static String getCharsetFromContentType(Buffer value) {
        String charset;
        int i;
        if (value instanceof BufferCache.CachedBuffer) {
            switch (((BufferCache.CachedBuffer)value).getOrdinal()) {
                case 7: 
                case 8: 
                case 9: {
                    return StringUtil.__ISO_8859_1;
                }
                case 10: 
                case 11: 
                case 12: {
                    return "UTF-8";
                }
            }
        }
        if ((i = (charset = value.toString()).indexOf(59)) > 0 && (i = charset.indexOf("charset", i)) > 0 && (i = charset.indexOf(61, i + 6)) > 0) {
            int s;
            for (s = i + 1; s < charset.length() && charset.charAt(s) == ' '; ++s) {
            }
            i = charset.indexOf(32, s);
            if (i < 0) {
                i = charset.indexOf(59, s);
            }
            if (i < 0) {
                return charset.substring(s);
            }
            return charset.substring(s, i);
        }
        return null;
    }

    static {
        ResourceBundle mime = ResourceBundle.getBundle("org/mortbay/jetty/mime");
        Enumeration<String> i = mime.getKeys();
        while (i.hasMoreElements()) {
            String ext = i.nextElement();
            String m = mime.getString(ext);
            __dftMimeMap.put(StringUtil.asciiToLowerCase((String)ext), MimeTypes.normalizeMimeType(m));
        }
        ResourceBundle encoding = ResourceBundle.getBundle("org/mortbay/jetty/encoding");
        i = encoding.getKeys();
        while (i.hasMoreElements()) {
            Buffer type = MimeTypes.normalizeMimeType(i.nextElement());
            __encodings.put(type, encoding.getString(type.toString()));
        }
        TEXT_HTML_BUFFER.setAssociate("ISO-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("ISO_8859_1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("iso-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO_8859_1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("iso-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO_8859_1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("iso-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf-8", TEXT_XML_UTF_8_BUFFER);
    }
}

