/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class RootItem
extends AbstractItemObj {
    private static final String NAME_DEFAULT = "";
    private static final int PARENTID_DEFAULT = 0;
    private static final int ID_DEFAULT = 0;
    private static final int TYPE_GROUPIDS = 200;
    @Nullable
    private int[] groupids;

    public RootItem(SsiItem item) {
        DefensiveTools.checkNull((Object)item, (String)"item");
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        Tlv groupTlv = chain.getLastTlv(200);
        if (groupTlv != null) {
            ByteBlock groupBlock = groupTlv.getData();
            this.groupids = new int[groupBlock.getLength() / 2];
            for (int i = 0; i < this.groupids.length; ++i) {
                this.groupids[i] = BinaryTools.getUShort((ByteBlock)groupBlock, (int)(i * 2));
            }
        } else {
            this.groupids = null;
        }
        MutableTlvChain extraTlvs = TlvTools.getMutableCopy(chain);
        extraTlvs.removeTlvs(new int[]{200});
        this.addExtraTlvs(extraTlvs);
    }

    public RootItem(RootItem other) {
        this(other.groupids == null ? null : (int[])other.groupids.clone(), other.copyExtraTlvs());
    }

    public RootItem() {
        this(null, null);
    }

    public RootItem(int[] groupids) {
        this(groupids, null);
    }

    public RootItem(int[] groupids, TlvChain extraTlvs) {
        super(extraTlvs);
        this.groupids = groupids == null ? null : (int[])groupids.clone();
    }

    @Nullable
    public final synchronized int[] getGroupids() {
        return this.groupids == null ? null : (int[])this.groupids.clone();
    }

    public final synchronized void setGroupids(@Nullable int[] groupids) {
        this.groupids = groupids == null ? null : (int[])groupids.clone();
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.groupids != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(this.groupids.length * 2);
            try {
                for (int groupid : this.groupids) {
                    BinaryTools.writeUShort((OutputStream)out, (int)groupid);
                }
            }
            catch (IOException impossible) {
                // empty catch block
            }
            ByteBlock tlvData = ByteBlock.wrap((byte[])out.toByteArray());
            chain.addTlv(new Tlv(200, (Writable)tlvData));
        }
        return this.generateItem(NAME_DEFAULT, 0, 0, 1, chain);
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int groupid : this.groupids) {
            buffer.append("0x");
            buffer.append(Integer.toHexString(groupid));
            buffer.append(", ");
        }
        return "RootItem with groupids: " + buffer;
    }
}

