/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.socket.nio.support;

import java.util.Queue;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.transport.socket.nio.support.DatagramAcceptorDelegate;
import org.apache.mina.transport.socket.nio.support.DatagramConnectorDelegate;
import org.apache.mina.transport.socket.nio.support.DatagramService;
import org.apache.mina.transport.socket.nio.support.DatagramSessionImpl;

class DatagramFilterChain
extends AbstractIoFilterChain {
    DatagramFilterChain(IoSession parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWrite(IoSession session, IoFilter.WriteRequest writeRequest) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        Queue<IoFilter.WriteRequest> writeRequestQueue = s.getWriteRequestQueue();
        ((ByteBuffer)writeRequest.getMessage()).mark();
        Queue<IoFilter.WriteRequest> queue = writeRequestQueue;
        synchronized (queue) {
            writeRequestQueue.add(writeRequest);
            if (writeRequestQueue.size() == 1 && session.getTrafficMask().isWritable()) {
                s.getManagerDelegate().flushSession(s);
            }
        }
    }

    protected void doClose(IoSession session) {
        DatagramSessionImpl s = (DatagramSessionImpl)session;
        DatagramService manager = s.getManagerDelegate();
        if (manager instanceof DatagramConnectorDelegate) {
            manager.closeSession(s);
        } else {
            ((DatagramAcceptorDelegate)manager).getListeners().fireSessionDestroyed(session);
            session.getCloseFuture().setClosed();
        }
    }
}

