/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.logic;

import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.logic.condition.BooleanConditionTask;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Assert
extends Task
implements TaskContainer {
    private boolean failOnError = true;
    private String execute = null;
    private boolean exists = true;
    private String value = null;
    private String name = null;
    private String message = "";
    private Task condition_task = null;
    private Vector tasks = new Vector();

    public void setName(String string) {
        this.name = string;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public void setMessage(String string) {
        if (string == null) {
            return;
        }
        this.message = string;
    }

    public void setExists(String string) {
        this.getProject();
        this.exists = Project.toBoolean((String)string);
    }

    public void setExecute(String string) {
        this.execute = string;
    }

    public void setFailonerror(String string) {
        this.failOnError = !(string = string.toLowerCase()).equals("false") && !string.equals("off") && !string.equals("no");
    }

    public void maybeConfigure() throws BuildException {
        if (this.isInvalid()) {
            super.maybeConfigure();
        } else {
            this.getRuntimeConfigurableWrapper().maybeConfigure(this.getProject(), false);
        }
    }

    public void addTask(Task task) {
        if (task instanceof BooleanConditionTask) {
            if (this.condition_task == null) {
                this.condition_task = task;
                return;
            }
            throw new BuildException("Only one <bool> allowed per If.");
        }
        this.tasks.addElement(task);
    }

    public void addBool(BooleanConditionTask booleanConditionTask) {
        this.addTask((Task)booleanConditionTask);
    }

    public void execute() throws BuildException {
        String string;
        block32: {
            block31: {
                String string2 = this.getProject().getProperty("ant.enable.asserts");
                if (string2 == null) break block31;
                this.getProject();
                if (Project.toBoolean((String)string2)) break block32;
            }
            this.executeNestedTasks();
            return;
        }
        if (this.condition_task == null) {
            String string3;
            if (this.name == null || this.name.equals("")) {
                throw new BuildException("The 'name' attribute is required.");
            }
            string = this.getProject().getProperty(this.name);
            if (this.exists && string == null) {
                string3 = "Assertion failed: Property '" + this.name + "' doesn't exist in this project.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(string3);
                }
                this.log(string3, 1);
            } else if (!this.exists && string != null) {
                string3 = "Assertion failed: Property '" + this.name + "' exists in this project, but shouldn't.\n" + this.message;
                if (this.failOnError) {
                    throw new BuildException(string3);
                }
                this.log(string3, 1);
            }
            if (this.value != null) {
                if (string == null) {
                    string3 = "Assertion failed: Expected '" + this.value + "', but was null\n" + this.message;
                    if (this.failOnError) {
                        throw new BuildException(string3);
                    }
                    this.log(string3, 1);
                } else if (string != null) {
                    string3 = string.toLowerCase();
                    boolean bl = false;
                    if (string3.equals("on") || string3.equals("yes") || string3.equals("true") || string3.equals("off") || string3.equals("no") || string3.equals("false")) {
                        bl = true;
                    }
                    if (bl) {
                        this.getProject();
                        boolean bl2 = Project.toBoolean((String)string);
                        this.getProject();
                        boolean bl3 = Project.toBoolean((String)this.value);
                        if (bl2 != bl3) {
                            String string4 = "Assertion failed: Expected '" + bl3 + "', but was '" + bl2 + "'.\n" + this.message;
                            if (this.failOnError) {
                                throw new BuildException(string4);
                            }
                            this.log(string4, 1);
                        }
                    } else if (!string.equals(this.value)) {
                        String string5 = "Assertion failed: Expected '" + this.value + "', but was '" + string + "'.\n" + this.message;
                        if (this.failOnError) {
                            throw new BuildException(string5);
                        }
                        this.log(string5, 1);
                    }
                }
            }
        } else if (!((BooleanConditionTask)this.condition_task).eval()) {
            string = "Assertion failed boolean test.\n" + this.message;
            if (this.failOnError) {
                throw new BuildException(string);
            }
            this.log(string, 1);
        }
        boolean bl = true;
        if (this.execute == null) {
            this.execute = this.getProject().getProperty("assert.execute");
            if (this.execute != null) {
                this.getProject();
                bl = Project.toBoolean((String)this.execute);
            }
        } else {
            this.getProject();
            bl = Project.toBoolean((String)this.execute);
        }
        if (bl) {
            this.executeNestedTasks();
        }
    }

    private void executeNestedTasks() {
        Enumeration enumeration = this.tasks.elements();
        while (enumeration.hasMoreElements()) {
            Task task = (Task)enumeration.nextElement();
            task.perform();
        }
    }

    public static int runTests() {
        Project project = new Project();
        Assert assert_ = new Assert();
        assert_.setProject(project);
        String string = "test_property";
        String string2 = "test_value";
        project.setProperty("ant.enable.asserts", "true");
        int n = 0;
        try {
            assert_.execute();
            throw new RuntimeException("test 1 failed.");
        }
        catch (Exception exception) {
            ++n;
            try {
                assert_.setName(string);
                assert_.execute();
                throw new RuntimeException("test 2 test failed.");
            }
            catch (Exception exception2) {
                ++n;
                try {
                    project.setProperty(string, string2);
                    assert_.setName(string);
                    assert_.execute();
                    ++n;
                }
                catch (Exception exception3) {
                    throw new RuntimeException("test 3 test failed:\n" + exception3.getMessage());
                }
                try {
                    assert_.setExists("false");
                    assert_.execute();
                    throw new RuntimeException("test 4 failed");
                }
                catch (Exception exception4) {
                    ++n;
                    try {
                        assert_.setExists("true");
                        assert_.setValue(string2);
                        assert_.execute();
                        ++n;
                    }
                    catch (Exception exception5) {
                        throw new RuntimeException("test 5 failed\n" + exception5.getMessage());
                    }
                    try {
                        assert_.setValue("blah");
                        assert_.execute();
                        throw new RuntimeException("test 6 failed");
                    }
                    catch (Exception exception6) {
                        ++n;
                        try {
                            assert_.setExists("true");
                            project.setProperty("boolean prop", "true");
                            assert_.setName("boolean prop");
                            assert_.setValue("tRue");
                            assert_.execute();
                            ++n;
                            assert_.setValue("on");
                            assert_.execute();
                            ++n;
                            assert_.setValue("Yes");
                            assert_.execute();
                            ++n;
                        }
                        catch (Exception exception7) {
                            throw new RuntimeException("test 7 failed\n" + exception7.getMessage());
                        }
                        try {
                            assert_.setValue("blah");
                            assert_.setFailonerror("false");
                            assert_.execute();
                            ++n;
                        }
                        catch (Exception exception8) {
                            throw new RuntimeException("test 10 failed");
                        }
                        try {
                            assert_.setValue("blah");
                            assert_.setFailonerror("true");
                            assert_.execute();
                            throw new RuntimeException("test 11 failed");
                        }
                        catch (Exception exception9) {
                            return ++n;
                        }
                    }
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        int n = Assert.runTests();
        System.out.println("Ran " + n + " tests, all passed.");
    }
}

