/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.log.Log;
import org.mortbay.util.IO;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    private File _docRoot;
    private String _path;
    private String _cmdPrefix;
    private EnvList _env;
    private boolean _ignoreExitState;

    public void init() throws ServletException {
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null && (tmp = this.getInitParameter("resourceBase")) == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        if (tmp == null) {
            Log.warn("CGI: no CGI bin !");
            throw new ServletException();
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            Log.warn("CGI: CGI bin does not exist - " + dir);
            throw new ServletException();
        }
        if (!dir.canRead()) {
            Log.warn("CGI: CGI bin is not readable - " + dir);
            throw new ServletException();
        }
        if (!dir.isDirectory()) {
            Log.warn("CGI: CGI bin is not a directory - " + dir);
            throw new ServletException();
        }
        try {
            this._docRoot = dir.getCanonicalFile();
        }
        catch (IOException e) {
            Log.warn("CGI: CGI bin failed - " + dir);
            e.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        this._ignoreExitState = "true".equalsIgnoreCase(this.getInitParameter("ignoreExitState"));
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        String pathInContext = StringUtil.nonNull(req.getServletPath()) + StringUtil.nonNull(req.getPathInfo());
        if (Log.isDebugEnabled()) {
            Log.debug("CGI: ContextPath : " + req.getContextPath());
            Log.debug("CGI: ServletPath : " + req.getServletPath());
            Log.debug("CGI: PathInfo    : " + req.getPathInfo());
            Log.debug("CGI: _docRoot    : " + this._docRoot);
            Log.debug("CGI: _path       : " + this._path);
            Log.debug("CGI: _ignoreExitState: " + this._ignoreExitState);
        }
        String first = both = pathInContext;
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists() || exe.isDirectory() || !exe.getCanonicalPath().equals(exe.getAbsolutePath())) {
            res.sendError(404);
        } else {
            if (Log.isDebugEnabled()) {
                Log.debug("CGI: script is " + exe);
                Log.debug("CGI: pathInfo is " + last);
            }
            this.exec(exe, last, req, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        String path = command.getAbsolutePath();
        File dir = command.getParentFile();
        String scriptName = req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length());
        String scriptPath = this.getServletContext().getRealPath(scriptName);
        String pathTranslated = req.getPathTranslated();
        int len = req.getContentLength();
        if (len < 0) {
            len = 0;
        }
        if (pathTranslated == null || pathTranslated.length() == 0) {
            pathTranslated = path;
        }
        EnvList env = new EnvList(this._env);
        env.set("AUTH_TYPE", req.getAuthType());
        env.set("CONTENT_LENGTH", Integer.toString(len));
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        if (pathInfo != null && pathInfo.length() > 0) {
            env.set("PATH_INFO", pathInfo);
        }
        env.set("PATH_TRANSLATED", pathTranslated);
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("REMOTE_USER", req.getRemoteUser());
        env.set("REQUEST_METHOD", req.getMethod());
        env.set("SCRIPT_NAME", scriptName);
        env.set("SCRIPT_FILENAME", scriptPath);
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String value = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase().replace('-', '_'), value);
        }
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        String execCmd = path;
        if (execCmd.charAt(0) != '\"' && execCmd.indexOf(" ") >= 0) {
            execCmd = "\"" + execCmd + "\"";
        }
        if (this._cmdPrefix != null) {
            execCmd = this._cmdPrefix + " " + execCmd;
        }
        Process p = dir == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir);
        ServletInputStream inFromReq = req.getInputStream();
        OutputStream outToCgi = p.getOutputStream();
        final int inLength = len;
        new Thread(new Runnable((InputStream)inFromReq, outToCgi){
            private final /* synthetic */ InputStream val$inFromReq;
            private final /* synthetic */ OutputStream val$outToCgi;
            {
                this.val$inFromReq = inputStream;
                this.val$outToCgi = outputStream;
            }

            public void run() {
                try {
                    if (inLength > 0) {
                        IO.copy(this.val$inFromReq, this.val$outToCgi, (long)inLength);
                    }
                    this.val$outToCgi.close();
                }
                catch (IOException e) {
                    Log.ignore(e);
                }
            }
        }).start();
        BufferedReader br = null;
        PrintWriter writer = null;
        try {
            int exitValue;
            String line = null;
            InputStream inFromCgi = p.getInputStream();
            br = new BufferedReader(new InputStreamReader(inFromCgi));
            while ((line = br.readLine()) != null && line.trim().length() != 0) {
                int k;
                if (line.startsWith("HTTP") || (k = line.indexOf(58)) <= 0) continue;
                String key = line.substring(0, k).trim();
                if ("Location".equals(key)) {
                    res.sendRedirect(line.substring(k + 1).trim());
                    continue;
                }
                if ("Status".equals(key)) {
                    int status = Integer.parseInt(line.substring(k + 1).trim());
                    res.setStatus(status);
                    continue;
                }
                res.addHeader(key, line.substring(k + 1));
            }
            writer = res.getWriter();
            IO.copy(br, writer);
            p.waitFor();
            if (!this._ignoreExitState && 0 != (exitValue = p.exitValue())) {
                Log.warn("Non-zero exit status (" + exitValue + ") from CGI program: " + path);
                if (!res.isCommitted()) {
                    res.sendError(500, "Failed to exec CGI");
                }
            }
        }
        catch (IOException e) {
            Log.debug("CGI: Client closed connection!");
        }
        catch (InterruptedException ie) {
            Log.debug("CGI: interrupted!");
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
            if (writer != null) {
                writer.close();
            }
            br = null;
            writer = null;
            p.destroy();
        }
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull(value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

