/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.logging.Logger;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.rvcmd.AcceptRvCmd;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joscar.rvcmd.RejectRvCmd;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.BuddyAcceptedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionSettings;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.StateBasedRvConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ManualTimeoutController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.BuddyCancelledEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ProxyRedirectDisallowedEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;

public abstract class AbstractRvSessionHandler
implements RendezvousSessionHandler {
    private static final Logger LOGGER = Logger.getLogger(AbstractRvSessionHandler.class.getName());
    private final RvConnection connection;

    public AbstractRvSessionHandler(RvConnection transfer) {
        this.connection = transfer;
    }

    protected final RvConnectionEvent getConnectError(RvConnectionInfo connInfo) {
        ProxyRedirectDisallowedEvent error = null;
        RvConnectionSettings settings = this.connection.getSettings();
        if (!(!settings.isOnlyUsingProxy() || connInfo.isProxied() && settings.isProxyRequestTrusted())) {
            error = new ProxyRedirectDisallowedEvent(connInfo.getProxyIP());
        }
        return error;
    }

    private synchronized ManualTimeoutController getManualTimeoutController() {
        if (!(this.connection instanceof StateBasedRvConnection)) {
            return null;
        }
        StateBasedRvConnection stateBasedRvConnection = (StateBasedRvConnection)this.connection;
        StateController controller = stateBasedRvConnection.getStateController();
        if (!(controller instanceof ManualTimeoutController)) {
            return null;
        }
        return (ManualTimeoutController)((Object)controller);
    }

    protected HowToConnect processRedirect(ConnectionRequestRvCmd reqCmd) {
        HowToConnect how;
        RvSessionConnectionInfo sessionInfo = this.connection.getRvSessionInfo();
        sessionInfo.setRequestIndex(reqCmd.getRequestIndex());
        RvConnectionInfo connInfo = reqCmd.getConnInfo();
        LOGGER.fine("Received redirect packet: " + reqCmd + " - to " + connInfo);
        RvConnectionEvent error = this.getConnectError(connInfo);
        if (error == null) {
            sessionInfo.setConnectionInfo(connInfo);
            LOGGER.fine("Storing connection info for redirect: " + connInfo);
            if (connInfo.isProxied()) {
                LOGGER.finer("Deciding to change to proxy connect controller");
                how = HowToConnect.PROXY;
                sessionInfo.setInitiator(Initiator.BUDDY);
            } else {
                LOGGER.finer("Deciding to change to normal connect controller");
                how = HowToConnect.NORMAL;
                sessionInfo.setInitiator(Initiator.BUDDY);
            }
        } else {
            how = HowToConnect.DONT;
        }
        return how;
    }

    public final void handleRv(RecvRvEvent event) {
        RvCommand cmd = event.getRvCommand();
        if (cmd instanceof ConnectionRequestRvCmd) {
            this.handleIncomingRequest(event, (ConnectionRequestRvCmd)cmd);
        } else if (cmd instanceof AcceptRvCmd) {
            this.handleIncomingAccept(event, (AcceptRvCmd)cmd);
        } else if (cmd instanceof RejectRvCmd) {
            this.handleIncomingReject(event, (RejectRvCmd)cmd);
        }
    }

    protected void handleIncomingReject(RecvRvEvent event, RejectRvCmd rejectCmd) {
        this.connection.close(new BuddyCancelledEvent(rejectCmd.getRejectCode()));
    }

    protected void handleIncomingAccept(RecvRvEvent event, AcceptRvCmd acceptCmd) {
        this.connection.getEventPost().fireEvent(new BuddyAcceptedEvent());
        ManualTimeoutController mtc = this.getManualTimeoutController();
        if (mtc != null) {
            mtc.startTimeoutTimer();
        }
    }

    protected abstract void handleIncomingRequest(RecvRvEvent var1, ConnectionRequestRvCmd var2);

    public void handleSnacResponse(RvSnacResponseEvent event) {
    }

    protected RvConnection getRvConnection() {
        return this.connection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HowToConnect {
        DONT,
        PROXY,
        NORMAL;

    }
}

