/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Attachment;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.Cancellable;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.SendingAttachmentDataEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.SendingAttachmentNullPaddingEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.AbstractTransferrer;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.EventPost;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;

class AttachmentSender
extends AbstractTransferrer {
    private ByteBuffer buf;
    private ReadableByteChannel inchan;
    private final Attachment data;
    private final EventPost post;
    private final String id;
    private final int attachno;
    private final int numattachments;
    private Cancellable cancellable;

    public AttachmentSender(StreamInfo stream, Attachment data, EventPost post, String id, int attachno, int numattachments, Cancellable cancellable) throws IOException {
        super(stream, 0L, data.getLength());
        this.data = data;
        this.post = post;
        this.id = id;
        this.attachno = attachno;
        this.numattachments = numattachments;
        this.resizeBuffer(1024);
        this.inchan = data.openForReading();
        this.cancellable = cancellable;
    }

    public void resizeBuffer(int size) {
        this.buf = ByteBuffer.allocate(size);
    }

    protected int getSelectionKey() {
        return 4;
    }

    protected boolean isCancelled() {
        return this.cancellable.isCancelled();
    }

    protected boolean waitIfPaused() {
        return false;
    }

    protected long transfer(ReadableByteChannel readable, WritableByteChannel writable, long transferred, long remaining) throws IOException {
        this.buf.rewind();
        this.buf.limit((int)Math.min((long)this.buf.capacity(), remaining));
        int read = this.inchan.read(this.buf);
        if (read == -1) {
            this.buf.position(0);
            this.buf.limit((int)Math.min((long)this.buf.capacity(), remaining));
            this.post.fireEvent(new SendingAttachmentNullPaddingEvent(this.id, transferred, this.data.getLength(), this.attachno, this.numattachments));
        } else {
            this.post.fireEvent(new SendingAttachmentDataEvent(this.id, transferred, this.data.getLength(), this.attachno, this.numattachments));
            this.buf.flip();
        }
        int wrote = writable.write(this.buf);
        return wrote;
    }
}

