/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.SIPObject;

public class Credentials
extends SIPObject {
    private static String DOMAIN = "domain";
    private static String REALM = "realm";
    private static String OPAQUE = "opaque";
    private static String ALGORITHM = "algorithm";
    private static String QOP = "qop";
    private static String STALE = "stale";
    private static String SIGNATURE = "signature";
    private static String RESPONSE = "response";
    private static String SIGNED_BY = "signed-by";
    private static String URI = "uri";
    private static String NONCE = "nonce";
    private static String NONCE_COUNT = "nc";
    private static String CNONCE = "cnonce";
    private static String USERNAME = "username";
    protected String scheme;
    protected NameValueList parameters = new NameValueList();

    public Credentials() {
        this.parameters.setSeparator(",");
    }

    public NameValueList getCredentials() {
        return this.parameters;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String s) {
        this.scheme = s;
    }

    public void setCredentials(NameValueList c) {
        this.parameters = c;
    }

    public String encode() {
        String retval = this.scheme;
        if (!this.parameters.isEmpty()) {
            retval = retval + " " + this.parameters.encode();
        }
        return retval;
    }

    public void setCredential(NameValue nameValue) {
        if (nameValue.getName().compareToIgnoreCase(URI) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(NONCE) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(REALM) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(CNONCE) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(RESPONSE) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(OPAQUE) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(USERNAME) == 0) {
            nameValue.setQuotedValue();
        } else if (nameValue.getName().compareToIgnoreCase(DOMAIN) == 0) {
            nameValue.setQuotedValue();
        }
        this.parameters.set(nameValue);
    }

    public Object clone() {
        Credentials retval = (Credentials)super.clone();
        if (this.parameters != null) {
            retval.parameters = (NameValueList)this.parameters.clone();
        }
        return retval;
    }
}

