/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;

class RoomListenerMultiplexor
implements ConnectionListener {
    private static final Map<Connection, WeakReference<RoomListenerMultiplexor>> monitors = new WeakHashMap<Connection, WeakReference<RoomListenerMultiplexor>>();
    private Connection connection;
    private RoomMultiplexFilter filter;
    private RoomMultiplexListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomListenerMultiplexor getRoomMultiplexor(Connection conn) {
        Map<Connection, WeakReference<RoomListenerMultiplexor>> map = monitors;
        synchronized (map) {
            if (!monitors.containsKey(conn) || monitors.get(conn).get() == null) {
                RoomListenerMultiplexor rm = new RoomListenerMultiplexor(conn, new RoomMultiplexFilter(), new RoomMultiplexListener());
                rm.init();
                monitors.put(conn, new WeakReference<RoomListenerMultiplexor>(rm));
            }
            return (RoomListenerMultiplexor)monitors.get(conn).get();
        }
    }

    private RoomListenerMultiplexor(Connection connection, RoomMultiplexFilter filter, RoomMultiplexListener listener) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.connection = connection;
        this.filter = filter;
        this.listener = listener;
    }

    public void addRoom(String address, PacketMultiplexListener roomListener) {
        this.filter.addRoom(address);
        this.listener.addRoom(address, roomListener);
    }

    @Override
    public void connectionClosed() {
        this.cancel();
    }

    @Override
    public void connectionClosedOnError(Exception e) {
        this.cancel();
    }

    @Override
    public void reconnectingIn(int seconds) {
    }

    @Override
    public void reconnectionSuccessful() {
    }

    @Override
    public void reconnectionFailed(Exception e) {
    }

    public void init() {
        this.connection.addConnectionListener(this);
        this.connection.addPacketListener(this.listener, this.filter);
    }

    public void removeRoom(String address) {
        this.filter.removeRoom(address);
        this.listener.removeRoom(address);
    }

    private void cancel() {
        this.connection.removeConnectionListener(this);
        this.connection.removePacketListener(this.listener);
    }

    private static class RoomMultiplexListener
    implements PacketListener {
        private Map<String, PacketMultiplexListener> roomListenersByAddress = new ConcurrentHashMap<String, PacketMultiplexListener>();

        private RoomMultiplexListener() {
        }

        @Override
        public void processPacket(Packet p) {
            String from = p.getFrom();
            if (from == null) {
                return;
            }
            PacketMultiplexListener listener = this.roomListenersByAddress.get(StringUtils.parseBareAddress(from).toLowerCase());
            if (listener != null) {
                listener.processPacket(p);
            }
        }

        public void addRoom(String address, PacketMultiplexListener listener) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.put(address.toLowerCase(), listener);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.remove(address.toLowerCase());
        }
    }

    private static class RoomMultiplexFilter
    implements PacketFilter {
        private Map<String, String> roomAddressTable = new ConcurrentHashMap<String, String>();

        private RoomMultiplexFilter() {
        }

        @Override
        public boolean accept(Packet p) {
            String from = p.getFrom();
            if (from == null) {
                return false;
            }
            return this.roomAddressTable.containsKey(StringUtils.parseBareAddress(from).toLowerCase());
        }

        public void addRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.put(address.toLowerCase(), address);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.remove(address.toLowerCase());
        }
    }
}

