/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.xiph.speex.spi.Pcm2SpeexAudioInputStream;
import org.xiph.speex.spi.Speex2PcmAudioInputStream;
import org.xiph.speex.spi.SpeexEncoding;

public class SpeexFormatConvertionProvider
extends FormatConversionProvider {
    public static final AudioFormat.Encoding[] NO_ENCODING = new AudioFormat.Encoding[0];
    public static final AudioFormat.Encoding[] PCM_ENCODING = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
    public static final AudioFormat.Encoding[] SPEEX_ENCODING = new AudioFormat.Encoding[]{SpeexEncoding.SPEEX};
    public static final AudioFormat.Encoding[] BOTH_ENCODINGS = new AudioFormat.Encoding[]{SpeexEncoding.SPEEX, AudioFormat.Encoding.PCM_SIGNED};
    public static final AudioFormat[] NO_FORMAT = new AudioFormat[0];

    public AudioFormat.Encoding[] getSourceEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{SpeexEncoding.SPEEX, AudioFormat.Encoding.PCM_SIGNED};
        return encodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{SpeexEncoding.SPEEX_Q0, SpeexEncoding.SPEEX_Q1, SpeexEncoding.SPEEX_Q2, SpeexEncoding.SPEEX_Q3, SpeexEncoding.SPEEX_Q4, SpeexEncoding.SPEEX_Q5, SpeexEncoding.SPEEX_Q6, SpeexEncoding.SPEEX_Q7, SpeexEncoding.SPEEX_Q8, SpeexEncoding.SPEEX_Q9, SpeexEncoding.SPEEX_Q10, SpeexEncoding.SPEEX_VBR0, SpeexEncoding.SPEEX_VBR1, SpeexEncoding.SPEEX_VBR2, SpeexEncoding.SPEEX_VBR3, SpeexEncoding.SPEEX_VBR4, SpeexEncoding.SPEEX_VBR5, SpeexEncoding.SPEEX_VBR6, SpeexEncoding.SPEEX_VBR7, SpeexEncoding.SPEEX_VBR8, SpeexEncoding.SPEEX_VBR9, SpeexEncoding.SPEEX_VBR10, AudioFormat.Encoding.PCM_SIGNED};
        return encodings;
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{SpeexEncoding.SPEEX_Q0, SpeexEncoding.SPEEX_Q1, SpeexEncoding.SPEEX_Q2, SpeexEncoding.SPEEX_Q3, SpeexEncoding.SPEEX_Q4, SpeexEncoding.SPEEX_Q5, SpeexEncoding.SPEEX_Q6, SpeexEncoding.SPEEX_Q7, SpeexEncoding.SPEEX_Q8, SpeexEncoding.SPEEX_Q9, SpeexEncoding.SPEEX_Q10, SpeexEncoding.SPEEX_VBR0, SpeexEncoding.SPEEX_VBR1, SpeexEncoding.SPEEX_VBR2, SpeexEncoding.SPEEX_VBR3, SpeexEncoding.SPEEX_VBR4, SpeexEncoding.SPEEX_VBR5, SpeexEncoding.SPEEX_VBR6, SpeexEncoding.SPEEX_VBR7, SpeexEncoding.SPEEX_VBR8, SpeexEncoding.SPEEX_VBR9, SpeexEncoding.SPEEX_VBR10};
            return encodings;
        }
        if (sourceFormat.getEncoding() instanceof SpeexEncoding) {
            AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};
            return encodings;
        }
        AudioFormat.Encoding[] encodings = new AudioFormat.Encoding[]{};
        return encodings;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetEncoding instanceof SpeexEncoding) {
            if (sourceFormat.getChannels() > 2 || sourceFormat.getChannels() <= 0 || sourceFormat.isBigEndian()) {
                AudioFormat[] formats = new AudioFormat[]{};
                return formats;
            }
            AudioFormat[] formats = new AudioFormat[]{new AudioFormat(targetEncoding, sourceFormat.getSampleRate(), -1, sourceFormat.getChannels(), -1, -1.0f, false)};
            return formats;
        }
        if (sourceFormat.getEncoding() instanceof SpeexEncoding && targetEncoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            AudioFormat[] formats = new AudioFormat[]{new AudioFormat(sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), true, false)};
            return formats;
        }
        AudioFormat[] formats = new AudioFormat[]{};
        return formats;
    }

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetEncoding, sourceStream.getFormat())) {
            AudioFormat[] formats = this.getTargetFormats(targetEncoding, sourceStream.getFormat());
            if (formats != null && formats.length > 0) {
                AudioFormat targetFormat;
                AudioFormat sourceFormat = sourceStream.getFormat();
                if (sourceFormat.equals(targetFormat = formats[0])) {
                    return sourceStream;
                }
                if (sourceFormat.getEncoding() instanceof SpeexEncoding && targetFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    return new Speex2PcmAudioInputStream(sourceStream, targetFormat, -1L);
                }
                if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetFormat.getEncoding() instanceof SpeexEncoding) {
                    return new Pcm2SpeexAudioInputStream(sourceStream, targetFormat, -1L);
                }
                throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
            }
            throw new IllegalArgumentException("target format not found");
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (this.isConversionSupported(targetFormat, sourceStream.getFormat())) {
            AudioFormat[] formats = this.getTargetFormats(targetFormat.getEncoding(), sourceStream.getFormat());
            if (formats != null && formats.length > 0) {
                AudioFormat sourceFormat = sourceStream.getFormat();
                if (sourceFormat.equals(targetFormat)) {
                    return sourceStream;
                }
                if (sourceFormat.getEncoding() instanceof SpeexEncoding && targetFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
                    return new Speex2PcmAudioInputStream(sourceStream, targetFormat, -1L);
                }
                if (sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && targetFormat.getEncoding() instanceof SpeexEncoding) {
                    return new Pcm2SpeexAudioInputStream(sourceStream, targetFormat, -1L);
                }
                throw new IllegalArgumentException("unable to convert " + sourceFormat.toString() + " to " + targetFormat.toString());
            }
            throw new IllegalArgumentException("target format not found");
        }
        throw new IllegalArgumentException("conversion not supported");
    }
}

