/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.impl.client.InvocationClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.QueryResult;
import com.hazelcast.map.impl.operation.QueryOperation;
import com.hazelcast.map.impl.operation.QueryPartitionOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

abstract class AbstractMapQueryRequest
extends InvocationClientRequest
implements Portable,
SecureRequest,
RetryableRequest {
    protected IterationType iterationType;
    private String name;

    public AbstractMapQueryRequest() {
    }

    public AbstractMapQueryRequest(String name, IterationType iterationType) {
        this.name = name;
        this.iterationType = iterationType;
    }

    @Override
    protected final void invoke() {
        QueryResultSet result = new QueryResultSet(null, this.iterationType, true);
        try {
            Predicate predicate = this.getPredicate();
            Collection<MemberImpl> members = this.getClientEngine().getClusterService().getMemberList();
            ArrayList<Future> futures = new ArrayList<Future>();
            this.createInvocations(members, futures, predicate);
            int partitionCount = this.getClientEngine().getPartitionService().getPartitionCount();
            HashSet<Integer> finishedPartitions = new HashSet<Integer>(partitionCount);
            this.collectResults(result, futures, finishedPartitions);
            if (this.hasMissingPartitions(finishedPartitions, partitionCount)) {
                List<Integer> missingList = this.findMissingPartitions(finishedPartitions, partitionCount);
                ArrayList<Future> missingFutures = new ArrayList<Future>(missingList.size());
                this.createInvocationsForMissingPartitions(missingList, missingFutures, predicate);
                this.collectResultsFromMissingPartitions(result, missingFutures);
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        this.getEndpoint().sendResponse(result, this.getCallId());
    }

    private void createInvocations(Collection<MemberImpl> members, List<Future> futures, Predicate predicate) {
        for (MemberImpl member : members) {
            InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)new QueryOperation(this.name, predicate), member.getAddress()).invoke();
            futures.add(future);
        }
    }

    private void collectResults(QueryResultSet result, List<Future> futures, Set<Integer> finishedPartitions) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            Collection<Integer> partitionIds;
            QueryResult queryResult = (QueryResult)future.get();
            if (queryResult == null || (partitionIds = queryResult.getPartitionIds()) == null) continue;
            finishedPartitions.addAll(partitionIds);
            result.addAll(queryResult.getResult());
        }
    }

    private boolean hasMissingPartitions(Set<Integer> finishedPartitions, int partitionCount) {
        return finishedPartitions.size() != partitionCount;
    }

    private List<Integer> findMissingPartitions(Set<Integer> finishedPartitions, int partitionCount) {
        ArrayList<Integer> missingList = new ArrayList<Integer>();
        for (int i = 0; i < partitionCount; ++i) {
            if (finishedPartitions.contains(i)) continue;
            missingList.add(i);
        }
        return missingList;
    }

    private void createInvocationsForMissingPartitions(List<Integer> missingPartitionsList, List<Future> futures, Predicate predicate) {
        for (Integer partitionId : missingPartitionsList) {
            QueryPartitionOperation queryPartitionOperation = new QueryPartitionOperation(this.name, predicate);
            queryPartitionOperation.setPartitionId(partitionId);
            try {
                InternalCompletableFuture future = this.createInvocationBuilder("hz:impl:mapService", (Operation)queryPartitionOperation, partitionId).invoke();
                futures.add(future);
            }
            catch (Throwable t) {
                throw ExceptionUtil.rethrow(t);
            }
        }
    }

    private void collectResultsFromMissingPartitions(QueryResultSet result, List<Future> futures) throws InterruptedException, ExecutionException {
        for (Future future : futures) {
            QueryResult queryResult = (QueryResult)future.get();
            result.addAll(queryResult.getResult());
        }
    }

    @Override
    public final int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("t", this.iterationType.toString());
        this.writePortableInner(writer);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.iterationType = IterationType.valueOf(reader.readUTF("t"));
        this.readPortableInner(reader);
    }

    protected abstract Predicate getPredicate();

    protected abstract void writePortableInner(PortableWriter var1) throws IOException;

    protected abstract void readPortableInner(PortableReader var1) throws IOException;
}

