/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.counters;

import com.hazelcast.nio.UnsafeHelper;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.counters.Counter;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import sun.misc.Unsafe;

public abstract class SwCounter
implements Counter {
    private SwCounter() {
    }

    public static SwCounter newSwCounter() {
        return SwCounter.newSwCounter(0L);
    }

    public static SwCounter newSwCounter(long initialValue) {
        if (UnsafeHelper.UNSAFE_AVAILABLE) {
            return new UnsafeSwCounter(initialValue);
        }
        return new SafeSwCounter(initialValue);
    }

    static final class SafeSwCounter
    extends SwCounter {
        private static final AtomicLongFieldUpdater<SafeSwCounter> COUNTER = AtomicLongFieldUpdater.newUpdater(SafeSwCounter.class, "value");
        private volatile long value;

        protected SafeSwCounter(long initialValue) {
            this.value = initialValue;
        }

        @Override
        public void inc() {
            COUNTER.lazySet(this, this.value + 1L);
        }

        @Override
        public void inc(long amount) {
            COUNTER.lazySet(this, this.value + amount);
        }

        @Override
        public long get() {
            return this.value;
        }

        public String toString() {
            return "Counter{value=" + this.value + '}';
        }
    }

    static final class UnsafeSwCounter
    extends SwCounter {
        private static final Unsafe UNSAFE = UnsafeHelper.UNSAFE;
        private static final long OFFSET;
        private long localValue;
        private volatile long value;

        protected UnsafeSwCounter(long initialValue) {
            this.value = initialValue;
        }

        @Override
        public void inc() {
            long newLocalValue = ++this.localValue;
            UNSAFE.putOrderedLong(this, OFFSET, newLocalValue);
        }

        @Override
        public void inc(long amount) {
            long newLocalValue = this.localValue += amount;
            UNSAFE.putOrderedLong(this, OFFSET, newLocalValue);
        }

        @Override
        public long get() {
            return this.value;
        }

        public String toString() {
            return "Counter{value=" + this.value + '}';
        }

        static {
            Field field = null;
            try {
                field = UnsafeSwCounter.class.getDeclaredField("value");
            }
            catch (NoSuchFieldException ignore) {
                EmptyStatement.ignore(ignore);
            }
            OFFSET = UnsafeHelper.UNSAFE.objectFieldOffset(field);
        }
    }
}

