/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import javax.media.Buffer;
import net.sf.fmj.media.rtp.RTPRawReceiver;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SourceRTPPacket;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.RTPPacket;

public class RTPDemultiplexer {
    private SSRCCache cache;
    private RTPRawReceiver rtpr;
    private Buffer buffer;
    private StreamSynch streamSynch;

    public RTPDemultiplexer(SSRCCache sSRCCache, RTPRawReceiver rTPRawReceiver, StreamSynch streamSynch) {
        this.cache = sSRCCache;
        this.rtpr = rTPRawReceiver;
        this.streamSynch = streamSynch;
        this.buffer = new Buffer();
    }

    public String consumerString() {
        return "RTP DeMultiplexer";
    }

    public void demuxpayload(SourceRTPPacket sourceRTPPacket) {
        SSRCInfo sSRCInfo = sourceRTPPacket.ssrcinfo;
        RTPPacket rTPPacket = sourceRTPPacket.p;
        sSRCInfo.payloadType = rTPPacket.payloadType;
        if (sSRCInfo.dstream != null) {
            this.buffer.setData(rTPPacket.base.data);
            this.buffer.setFlags(rTPPacket.flags);
            if (rTPPacket.marker == 1) {
                this.buffer.setFlags(this.buffer.getFlags() | 0x800);
            }
            this.buffer.setLength(rTPPacket.payloadlength);
            this.buffer.setOffset(rTPPacket.payloadoffset);
            long l = this.streamSynch.calcTimestamp(sSRCInfo.ssrc, rTPPacket.payloadType, rTPPacket.timestamp);
            this.buffer.setTimeStamp(l);
            this.buffer.setRtpTimeStamp(rTPPacket.timestamp);
            this.buffer.setFlags(this.buffer.getFlags() | 0x1000);
            this.buffer.setSequenceNumber(rTPPacket.seqnum);
            this.buffer.setFormat(sSRCInfo.dstream.getFormat());
            sSRCInfo.dstream.add(this.buffer, sSRCInfo.wrapped, this.rtpr);
        }
    }
}

