/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIManager;
import net.sf.fmj.ejmf.toolkit.gui.controls.GainMeter;
import net.sf.fmj.ejmf.toolkit.gui.controls.skins.ejmf.BasicControlButton;

public class GainMeterButton
extends BasicControlButton
implements GainMeter {
    protected int intLevel;
    protected boolean muted;

    public GainMeterButton() {
    }

    public GainMeterButton(float f, boolean bl) {
        this.setLevel(f);
        this.setMute(bl);
    }

    protected int getResolution() {
        return 5;
    }

    public int mapToMeterLevel(float f) {
        int n = this.getResolution();
        int n2 = (int)(f * 10.0f);
        int n3 = 10 / n;
        return n2 / n3;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        Color color = graphics.getColor();
        boolean bl = this.getModel().isPressed();
        boolean bl2 = this.isEnabled();
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        if (bl) {
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawRect(0, 0, n - 1, n2 - 1);
        } else {
            graphics.drawLine(0, 0, 0, n2 - 1);
            graphics.drawLine(1, 0, n - 2, 0);
            graphics.setColor(UIManager.getColor("controlHighlight"));
            graphics.drawLine(1, 1, 1, n2 - 3);
            graphics.drawLine(2, 1, n - 3, 1);
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(1, n2 - 2, n - 2, n2 - 2);
            graphics.drawLine(n - 2, 1, n - 2, n2 - 3);
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            graphics.drawLine(n - 1, n2 - 1, n - 1, 0);
        }
        if (n2 < 5 || n < 5) {
            graphics.setColor(color);
            return;
        }
        if (bl) {
            graphics.translate(1, 1);
        }
        int n3 = Math.min((n2 - 4) / 3, (n - 4) / 3);
        n3 = Math.max(n3, 2);
        this.paintIcon(graphics, (n - n3) / 2, (n2 - n3) / 2, n3, bl2);
        if (bl) {
            graphics.translate(-1, -1);
        }
        graphics.setColor(color);
    }

    protected void paintIcon(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4;
        int n5 = this.muted ? n : n - 3;
        graphics.translate(n5, n2);
        int n6 = n3 / 2;
        int n7 = n3 / 5;
        for (n4 = 0; n4 < n3 / 5; ++n4) {
            graphics.drawLine(n4, n6 - n7, n4, n6 + n7);
        }
        for (n4 = 0; n4 < n3; ++n4) {
            graphics.drawLine(n4, n6 - n4, n4, n6 + n4);
        }
        n4 = this.intLevel;
        if (!this.muted) {
            for (int i = 0; i < n4; ++i) {
                graphics.drawArc(n3, n6 - (i + 1), i * 2, i * 2 + 1, 90, -180);
            }
        }
        if (this.muted) {
            graphics.translate(-2, -2);
            Color color = graphics.getColor();
            graphics.setColor(Color.red);
            graphics.drawLine(0, 0, n3 + 2, n3 + 2);
            graphics.drawLine(0, n3 + 2, n3 + 2, 0);
            graphics.setColor(color);
            graphics.translate(2, 2);
        }
        graphics.translate(-n5, -n2);
    }

    public void setLevel(float f) {
        this.intLevel = this.mapToMeterLevel(f);
        this.updateView();
    }

    public void setMute(boolean bl) {
        this.muted = bl;
        this.updateView();
    }

    public void updateView() {
        this.repaint();
    }
}

