/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.concurrent.lock.operations.IsLockedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public abstract class AbstractIsLockedRequest
extends KeyBasedClientRequest {
    protected Data key;
    protected long threadId;

    public AbstractIsLockedRequest() {
    }

    public AbstractIsLockedRequest(Data key) {
        this.key = key;
    }

    protected AbstractIsLockedRequest(Data key, long threadId) {
        this(key);
        this.threadId = threadId;
    }

    protected String getName() {
        return (String)this.serializationService.toObject(this.key);
    }

    @Override
    protected final Operation prepareOperation() {
        return new IsLockedOperation(this.getNamespace(), this.key, this.threadId);
    }

    @Override
    protected final Object getKey() {
        return this.key;
    }

    protected abstract ObjectNamespace getNamespace();

    @Override
    public final String getServiceName() {
        return "hz:impl:lockService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeLong("tid", this.threadId);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.threadId = reader.readLong("tid");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
    }

    @Override
    public String getDistributedObjectName() {
        return (String)this.serializationService.toObject(this.key);
    }

    @Override
    public String getMethodName() {
        return "isLocked";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key};
    }
}

