/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private byte[] messageBody;
    private boolean errorFlag;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private int messageSize;
    private static int uid = 0;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPMessageListener sIPMessageListener, Pipeline pipeline, boolean bl, int n) {
        this();
        this.sipMessageListener = sIPMessageListener;
        this.rawInputStream = pipeline;
        this.maxMessageSize = n;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPMessageListener sIPMessageListener, Pipeline pipeline, int n) {
        this(sIPMessageListener, pipeline, false, n);
    }

    public PipelinedMsgParser(Pipeline pipeline) {
        this(null, pipeline, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser pipelinedMsgParser = new PipelinedMsgParser();
        pipelinedMsgParser.rawInputStream = this.rawInputStream;
        pipelinedMsgParser.sipMessageListener = this.sipMessageListener;
        Thread thread = new Thread(pipelinedMsgParser);
        thread.setName("PipelineThread");
        return pipelinedMsgParser;
    }

    public void setMessageListener(SIPMessageListener sIPMessageListener) {
        this.sipMessageListener = sIPMessageListener;
    }

    private String readLine(FilterInputStream filterInputStream) throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer("");
        do {
            int n;
            if ((n = filterInputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            c = (char)n;
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (c == '\r') continue;
            stringBuffer.append(c);
        } while (c != '\n');
        return stringBuffer.toString();
    }

    private String readToBreak(FilterInputStream filterInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        while ((n = filterInputStream.read()) != -1) {
            char c = (char)n;
            if (c != '\r') {
                stringBuffer.append(c);
            }
            if (c != '\n') continue;
            if (!bl) {
                bl = true;
                continue;
            }
            break;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        MyFilterInputStream myFilterInputStream = null;
        myFilterInputStream = new MyFilterInputStream(this.rawInputStream);
        while (true) {
            String string;
            String string2;
            StringBuffer stringBuffer;
            try {
                this.sizeCounter = this.maxMessageSize;
                this.messageSize = 0;
                stringBuffer = new StringBuffer();
                string2 = null;
                try {
                    while ((string = this.readLine(myFilterInputStream)).equals("\n")) {
                    }
                }
                catch (IOException iOException) {
                    Debug.printStackTrace(iOException);
                    this.rawInputStream.stopTimer();
                    try {
                        myFilterInputStream.close();
                        return;
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                try {
                    myFilterInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            {
                stringBuffer.append(string);
                this.rawInputStream.startTimer();
                try {
                    do {
                        string2 = this.readLine(myFilterInputStream);
                        stringBuffer.append(string2);
                    } while (!string2.trim().equals(""));
                }
                catch (IOException iOException) {
                    this.rawInputStream.stopTimer();
                    Debug.printStackTrace(iOException);
                    try {
                        myFilterInputStream.close();
                        return;
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                    return;
                }
            }
            {
                this.rawInputStream.stopTimer();
                stringBuffer.append(string2);
                StringMsgParser stringMsgParser = new StringMsgParser(this.sipMessageListener);
                stringMsgParser.readBody = false;
                SIPMessage sIPMessage = null;
                try {
                    sIPMessage = stringMsgParser.parseSIPMessage(stringBuffer.toString());
                    if (sIPMessage == null) {
                        this.rawInputStream.stopTimer();
                    }
                }
                catch (ParseException parseException) {}
                continue;
                ContentLength contentLength = (ContentLength)sIPMessage.getContentLength();
                int n = 0;
                n = contentLength != null ? contentLength.getContentLength() : 0;
                if (n == 0) {
                    sIPMessage.removeContent();
                } else if (this.maxMessageSize == 0 || n < this.sizeCounter) {
                    byte[] byArray = new byte[n];
                    int n2 = 0;
                    while (n2 < n) {
                        this.rawInputStream.startTimer();
                        try {
                            int n3 = myFilterInputStream.read(byArray, n2, n - n2);
                            if (n3 <= 0) break;
                            n2 += n3;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            break;
                        }
                        finally {
                            this.rawInputStream.stopTimer();
                        }
                    }
                    sIPMessage.setMessageContent(byArray);
                }
                if (this.sipMessageListener == null) continue;
                try {
                    this.sipMessageListener.processMessage(sIPMessage);
                }
                catch (Exception exception) {
                    try {
                        myFilterInputStream.close();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
        }
    }

    class MyFilterInputStream
    extends FilterInputStream {
        public MyFilterInputStream(InputStream inputStream) {
            super(inputStream);
        }
    }
}

