/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.util.Collection;
import java.util.Iterator;
import net.sf.cindy.Session;
import net.sf.cindy.SessionStatisticListener;
import net.sf.cindy.spi.DispatcherSpi;
import net.sf.cindy.spi.SessionStatisticSpi;
import net.sf.cindy.util.CopyOnWriteCollection;
import net.sf.cindy.util.Speed;

public class SimpleSessionStatistic
implements SessionStatisticSpi {
    private final Session session;
    private final Speed received = Speed.getInstance();
    private final Speed sent = Speed.getInstance();
    private final Collection listeners = new CopyOnWriteCollection();
    private boolean stopped = true;
    private double avgReceiveSpeed = 0.0;
    private double avgSendSpeed = 0.0;
    private long elapsedTime = 0L;

    public SimpleSessionStatistic(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public double getAvgReceiveSpeed() {
        if (this.stopped) {
            return this.avgReceiveSpeed;
        }
        return this.received.getAvgSpeed();
    }

    public double getAvgSendSpeed() {
        if (this.stopped) {
            return this.avgSendSpeed;
        }
        return this.sent.getAvgSpeed();
    }

    public long getElapsedTime() {
        if (this.stopped) {
            return this.elapsedTime;
        }
        return this.received.getElapsedTime();
    }

    public long getReceivedBytes() {
        return this.received.getTotalValue();
    }

    public long getSentBytes() {
        return this.sent.getTotalValue();
    }

    public double getReceiveSpeed() {
        if (this.stopped) {
            return 0.0;
        }
        return this.received.getSpeed();
    }

    public double getSendSpeed() {
        if (this.stopped) {
            return 0.0;
        }
        return this.sent.getSpeed();
    }

    public void addListener(SessionStatisticListener sessionStatisticListener) {
        if (sessionStatisticListener != null) {
            this.listeners.add(sessionStatisticListener);
        }
    }

    public void removeListener(SessionStatisticListener sessionStatisticListener) {
        if (sessionStatisticListener != null) {
            this.listeners.remove(sessionStatisticListener);
        }
    }

    private void dispatch(Runnable runnable) {
        ((DispatcherSpi)this.session.getDispatcher()).dispatch(this.session, runnable);
    }

    public void received(final long l) {
        this.received.addValue(l);
        this.dispatch(new Runnable(){

            public void run() {
                Iterator iterator = SimpleSessionStatistic.this.listeners.iterator();
                while (iterator.hasNext()) {
                    SessionStatisticListener sessionStatisticListener = (SessionStatisticListener)iterator.next();
                    sessionStatisticListener.received(SimpleSessionStatistic.this, l);
                }
            }
        });
    }

    public void sent(final long l) {
        this.sent.addValue(l);
        this.dispatch(new Runnable(){

            public void run() {
                Iterator iterator = SimpleSessionStatistic.this.listeners.iterator();
                while (iterator.hasNext()) {
                    SessionStatisticListener sessionStatisticListener = (SessionStatisticListener)iterator.next();
                    sessionStatisticListener.sent(SimpleSessionStatistic.this, l);
                }
            }
        });
    }

    public synchronized void start() {
        this.avgReceiveSpeed = 0.0;
        this.avgSendSpeed = 0.0;
        this.elapsedTime = 0L;
        this.received.reset();
        this.sent.reset();
        this.stopped = false;
    }

    public synchronized void stop() {
        this.avgReceiveSpeed = this.received.getAvgSpeed();
        this.avgSendSpeed = this.sent.getAvgSpeed();
        this.elapsedTime = this.received.getElapsedTime();
        this.stopped = true;
    }
}

