/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.helpers.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public class MDCFileAppender
extends AppenderSkeleton {
    private static final long EXPIRATION_TIME = 30000L;
    private final Map<String, MDCLogFile> openFiles = new HashMap<String, MDCLogFile>();
    private String fileValue;
    private String dirValue;
    private String keyValue;
    private PatternConverter filePatternConverter;
    private PatternConverter dirPatternConverter;
    private PatternConverter keyPatternConverter;
    private long logExpiresValue;
    private final Timer timer = new Timer();
    private boolean timerRunning = false;
    private final TimerTask closerTask = new CloserTask(this);
    private final ShutdownHook hook = new ShutdownHook();

    public boolean requiresLayout() {
        return true;
    }

    public void append(LoggingEvent event) {
        String key = this.getKeyName(event);
        if (key != null && key.length() != 0) {
            String message = this.layout.format(event);
            try {
                MDCLogFile logFile = this.openLogFile(key, event);
                logFile.write(message);
            }
            catch (IOException e) {
                LogLog.error((String)("error in appending to file for " + key));
            }
            if (!this.timerRunning) {
                Runtime.getRuntime().addShutdownHook(this.hook);
                this.timerRunning = true;
                this.timer.scheduleAtFixedRate(this.closerTask, 35000L, 35000L);
            }
        }
    }

    public void finalize() {
        super.finalize();
        if (this.closed) {
            return;
        }
        this.close();
    }

    public void close() {
        try {
            if (this.timerRunning) {
                this.timer.cancel();
            }
            this.closeAllFiles();
        }
        catch (IOException e) {
            LogLog.error((String)"error closing all files", (Throwable)e);
        }
    }

    public synchronized MDCLogFile openLogFile(String key, LoggingEvent event) throws IOException {
        MDCLogFile logFile = null;
        if (this.openFiles.containsKey(key)) {
            logFile = this.openFiles.get(key);
        } else {
            String dirName = this.getDirName(event);
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String fileName = dirName + '/' + this.getFileName(event);
            logFile = this.logExpiresValue > 0L ? new MDCLogFile(fileName, true, this.logExpiresValue) : new MDCLogFile(fileName, true);
            this.openFiles.put(key, logFile);
        }
        return logFile;
    }

    private String getKeyName(LoggingEvent event) {
        return this.format(event, this.keyPatternConverter);
    }

    private String getFileName(LoggingEvent event) {
        return this.format(event, this.filePatternConverter);
    }

    private String getDirName(LoggingEvent event) {
        return this.format(event, this.dirPatternConverter);
    }

    private String format(LoggingEvent event, PatternConverter patternConverter) {
        StringBuffer stringBuffer = new StringBuffer();
        PatternConverter c = patternConverter;
        while (c != null) {
            c.format(stringBuffer, event);
            c = c.next;
        }
        return stringBuffer.toString();
    }

    public synchronized void closeLogFile(String key) throws IOException {
        MDCLogFile logFile = this.getLogFile(key);
        logFile.close();
        this.openFiles.remove(key);
    }

    public synchronized MDCLogFile getLogFile(String key) {
        if (this.openFiles.containsKey(key)) {
            return this.openFiles.get(key);
        }
        return null;
    }

    public synchronized void closeExpiredFiles() throws IOException {
        Set<String> keys = this.openFiles.keySet();
        HashSet<String> removeKeys = new HashSet<String>();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                MDCLogFile logFile = this.openFiles.get(key);
                if (logFile == null) continue;
                if (logFile.isExpired()) {
                    logFile.close();
                    removeKeys.add(key);
                    continue;
                }
                logFile.flush();
            }
            if (!removeKeys.isEmpty()) {
                for (String key : removeKeys) {
                    this.openFiles.remove(key);
                }
            }
        }
    }

    public synchronized void closeAllFiles() throws IOException {
        Set<String> keys = this.openFiles.keySet();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                MDCLogFile logFile = this.openFiles.get(key);
                if (logFile == null) continue;
                logFile.close();
            }
            this.openFiles.clear();
        }
    }

    private PatternParser createPatternParser(String pattern) {
        return new PatternParser(pattern);
    }

    public void setFile(String fileValue) {
        this.fileValue = fileValue;
        this.filePatternConverter = this.createPatternParser(fileValue).parse();
    }

    public String getFile() {
        return this.fileValue;
    }

    public void setDir(String dirValue) {
        this.dirValue = dirValue;
        this.dirPatternConverter = this.createPatternParser(dirValue).parse();
    }

    public String getDir() {
        return this.dirValue;
    }

    public void setKey(String keyValue) {
        this.keyValue = keyValue;
        this.keyPatternConverter = this.createPatternParser(keyValue).parse();
    }

    public String getKey() {
        return this.keyValue;
    }

    public void setLogExpires(long logExpiresValue) {
        this.logExpiresValue = logExpiresValue;
    }

    public long getLogExpires() {
        return this.logExpiresValue;
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public void run() {
            try {
                MDCFileAppender.this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    final class CloserTask
    extends TimerTask {
        private MDCFileAppender appender;

        CloserTask(MDCFileAppender appender) {
            this.appender = appender;
        }

        public void run() {
            try {
                this.appender.closeExpiredFiles();
            }
            catch (IOException e) {
                LogLog.error((String)"error closing expired files", (Throwable)e);
            }
        }
    }

    final class MDCLogFile {
        private final Writer writer;
        private long lastWriteTime;
        private final long expirationTime;

        MDCLogFile(String fileName, boolean append) throws IOException {
            this(fileName, append, 1L);
        }

        MDCLogFile(String fileName, boolean append, long exp) throws IOException {
            this.expirationTime = exp;
            this.writer = new OutputStreamWriter(new FileOutputStream(fileName, append));
        }

        public void write(String msg) throws IOException {
            if (this.writer != null) {
                this.writer.write(msg);
            }
            this.lastWriteTime = System.currentTimeMillis();
        }

        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.close();
            }
        }

        public void flush() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
        }

        public boolean isExpired() {
            long cTime = System.currentTimeMillis();
            return this.expirationTime > 0L ? cTime - this.lastWriteTime >= this.expirationTime : cTime - this.lastWriteTime >= 30000L;
        }
    }
}

