/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.BinaryClassDefinition;
import com.hazelcast.nio.serialization.BinaryClassDefinitionProxy;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationContext;
import java.nio.ByteBuffer;

public class DataAdapter
implements SocketWritable,
SocketReadable {
    protected static int stBit = 0;
    private static final int stType = stBit++;
    private static final int stClassId = stBit++;
    private static final int stFactoryId = stBit++;
    private static final int stVersion = stBit++;
    private static final int stClassDefSize = stBit++;
    private static final int stClassDef = stBit++;
    private static final int stSize = stBit++;
    private static final int stValue = stBit++;
    private static final int stHash = stBit++;
    private static final int stAll = stBit++;
    private ByteBuffer buffer;
    private int factoryId = 0;
    private int classId = 0;
    private int version = 0;
    private int classDefSize = 0;
    private boolean skipClassDef = false;
    protected Data data;
    private transient short status = 0;
    private transient SerializationContext context;

    public DataAdapter(Data data) {
        this.data = data;
    }

    public DataAdapter(SerializationContext context) {
        this.context = context;
    }

    public DataAdapter(Data data, SerializationContext context) {
        this.data = data;
        this.context = context;
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (!this.isStatusSet(stType)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.type);
            this.setStatus(stType);
        }
        if (!this.isStatusSet(stClassId)) {
            if (destination.remaining() < 4) {
                return false;
            }
            this.classId = this.data.classDefinition == null ? 0 : this.data.classDefinition.getClassId();
            destination.putInt(this.classId);
            if (this.classId == 0) {
                this.setStatus(stFactoryId);
                this.setStatus(stVersion);
                this.setStatus(stClassDefSize);
                this.setStatus(stClassDef);
            }
            this.setStatus(stClassId);
        }
        if (!this.isStatusSet(stFactoryId)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.classDefinition.getFactoryId());
            this.setStatus(stFactoryId);
        }
        if (!this.isStatusSet(stVersion)) {
            if (destination.remaining() < 4) {
                return false;
            }
            int version = this.data.classDefinition.getVersion();
            destination.putInt(version);
            this.setStatus(stVersion);
        }
        if (!this.isStatusSet(stClassDefSize)) {
            if (destination.remaining() < 4) {
                return false;
            }
            BinaryClassDefinition cd = (BinaryClassDefinition)this.data.classDefinition;
            byte[] binary = cd.getBinary();
            this.classDefSize = binary == null ? 0 : binary.length;
            destination.putInt(this.classDefSize);
            this.setStatus(stClassDefSize);
            if (this.classDefSize == 0) {
                this.setStatus(stClassDef);
            } else {
                this.buffer = ByteBuffer.wrap(binary);
            }
        }
        if (!this.isStatusSet(stClassDef)) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.setStatus(stClassDef);
        }
        if (!this.isStatusSet(stSize)) {
            if (destination.remaining() < 4) {
                return false;
            }
            int size = this.data.bufferSize();
            destination.putInt(size);
            this.setStatus(stSize);
            if (size <= 0) {
                this.setStatus(stValue);
            } else {
                this.buffer = ByteBuffer.wrap(this.data.buffer);
            }
        }
        if (!this.isStatusSet(stValue)) {
            IOUtil.copyToHeapBuffer(this.buffer, destination);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.setStatus(stValue);
        }
        if (!this.isStatusSet(stHash)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.data.getPartitionHash());
            this.setStatus(stHash);
        }
        this.setStatus(stAll);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        if (this.data == null) {
            this.data = new Data();
        }
        if (!this.isStatusSet(stType)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.data.type = source.getInt();
            this.setStatus(stType);
        }
        if (!this.isStatusSet(stClassId)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.classId = source.getInt();
            this.setStatus(stClassId);
            if (this.classId == 0) {
                this.setStatus(stFactoryId);
                this.setStatus(stVersion);
                this.setStatus(stClassDefSize);
                this.setStatus(stClassDef);
            }
        }
        if (!this.isStatusSet(stFactoryId)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.factoryId = source.getInt();
            this.setStatus(stFactoryId);
        }
        if (!this.isStatusSet(stVersion)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.version = source.getInt();
            this.setStatus(stVersion);
        }
        if (!this.isStatusSet(stClassDef)) {
            ClassDefinition cd;
            if (!this.skipClassDef && (cd = this.context.lookup(this.factoryId, this.classId, this.version)) != null) {
                this.data.classDefinition = cd;
                this.skipClassDef = true;
            }
            if (!this.isStatusSet(stClassDefSize)) {
                if (source.remaining() < 4) {
                    return false;
                }
                this.classDefSize = source.getInt();
                this.setStatus(stClassDefSize);
            }
            if (!this.isStatusSet(stClassDef)) {
                if (source.remaining() < this.classDefSize) {
                    return false;
                }
                if (this.skipClassDef) {
                    source.position(this.classDefSize + source.position());
                } else {
                    byte[] binary = new byte[this.classDefSize];
                    source.get(binary);
                    this.data.classDefinition = new BinaryClassDefinitionProxy(this.factoryId, this.classId, this.version, binary);
                }
                this.setStatus(stClassDef);
            }
        }
        if (!this.isStatusSet(stSize)) {
            if (source.remaining() < 4) {
                return false;
            }
            int size = source.getInt();
            this.buffer = ByteBuffer.allocate(size);
            this.setStatus(stSize);
        }
        if (!this.isStatusSet(stValue)) {
            IOUtil.copyToHeapBuffer(source, this.buffer);
            if (this.buffer.hasRemaining()) {
                return false;
            }
            this.buffer.flip();
            this.data.buffer = this.buffer.array();
            this.setStatus(stValue);
        }
        if (!this.isStatusSet(stHash)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.data.partitionHash = source.getInt();
            this.setStatus(stHash);
        }
        this.setStatus(stAll);
        return true;
    }

    protected final void setStatus(int bit) {
        this.status = (short)(this.status | 1 << bit);
    }

    protected final boolean isStatusSet(int bit) {
        return (this.status & 1 << bit) != 0;
    }

    public final Data getData() {
        this.data.postConstruct(this.context);
        return this.data;
    }

    public final void setData(Data data) {
        this.data = data;
    }

    public boolean done() {
        return this.isStatusSet(stAll);
    }

    @Override
    public void onEnqueue() {
    }

    public void reset() {
        this.buffer = null;
        this.classId = 0;
        this.version = 0;
        this.classDefSize = 0;
        this.data = null;
        this.status = 0;
    }
}

