/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ItemListenerConfigReadOnly;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.core.ItemListener;

public class ItemListenerConfig
extends ListenerConfig {
    private boolean includeValue = true;
    private ItemListenerConfigReadOnly readOnly;

    public ItemListenerConfig() {
    }

    public ItemListenerConfig(String className, boolean includeValue) {
        super(className);
        this.includeValue = includeValue;
    }

    public ItemListenerConfig(ItemListener implementation, boolean includeValue) {
        super(implementation);
        this.includeValue = includeValue;
    }

    public ItemListenerConfig(ItemListenerConfig config) {
        this.includeValue = config.isIncludeValue();
        this.implementation = config.getImplementation();
        this.className = config.getClassName();
    }

    @Override
    public ItemListenerConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new ItemListenerConfigReadOnly(this);
        }
        return this.readOnly;
    }

    @Override
    public ItemListener getImplementation() {
        return (ItemListener)this.implementation;
    }

    public ItemListenerConfig setImplementation(ItemListener implementation) {
        super.setImplementation(implementation);
        return this;
    }

    @Override
    public boolean isIncludeValue() {
        return this.includeValue;
    }

    public ItemListenerConfig setIncludeValue(boolean includeValue) {
        this.includeValue = includeValue;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ItemListenerConfig");
        sb.append("{includeValue=").append(this.includeValue);
        sb.append('}');
        return sb.toString();
    }
}

