/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionItem;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.TxCollectionItem;
import com.hazelcast.config.CollectionConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CollectionContainer
implements DataSerializable {
    protected String name;
    protected NodeEngine nodeEngine;
    protected CollectionService service;
    protected ILogger logger;
    protected Map<Long, CollectionItem> itemMap = null;
    protected final Map<Long, TxCollectionItem> txMap = new HashMap<Long, TxCollectionItem>();
    private long idGenerator = 0L;

    protected CollectionContainer() {
    }

    protected CollectionContainer(String name, NodeEngine nodeEngine, CollectionService service) {
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.service = service;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public void init(NodeEngine nodeEngine, CollectionService service) {
        this.nodeEngine = nodeEngine;
        this.service = service;
    }

    protected abstract CollectionConfig getConfig();

    protected abstract Collection<CollectionItem> getCollection();

    protected abstract Map<Long, CollectionItem> getMap();

    protected long add(Data value) {
        CollectionItem item = new CollectionItem(this.nextId(), value);
        if (this.getCollection().add(item)) {
            return item.getItemId();
        }
        return -1L;
    }

    protected void addBackup(long itemId, Data value) {
        CollectionItem item = new CollectionItem(itemId, value);
        this.getMap().put(itemId, item);
    }

    protected CollectionItem remove(Data value) {
        Iterator<CollectionItem> iterator = this.getCollection().iterator();
        while (iterator.hasNext()) {
            CollectionItem item = iterator.next();
            if (!value.equals(item.getValue())) continue;
            iterator.remove();
            return item;
        }
        return null;
    }

    protected void removeBackup(long itemId) {
        this.getMap().remove(itemId);
    }

    protected int size() {
        return this.getCollection().size();
    }

    protected Map<Long, Data> clear() {
        Collection<CollectionItem> coll = this.getCollection();
        HashMap<Long, Data> itemIdMap = new HashMap<Long, Data>(coll.size());
        for (CollectionItem item : coll) {
            itemIdMap.put(item.getItemId(), (Data)item.getValue());
        }
        coll.clear();
        return itemIdMap;
    }

    protected void clearBackup(Set<Long> itemIdSet) {
        for (Long itemId : itemIdSet) {
            this.removeBackup(itemId);
        }
    }

    protected boolean contains(Set<Data> valueSet) {
        for (Data value : valueSet) {
            boolean contains = false;
            for (CollectionItem item : this.getCollection()) {
                if (!value.equals(item.getValue())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    protected Map<Long, Data> addAll(List<Data> valueList) {
        int size = valueList.size();
        HashMap<Long, Data> map = new HashMap<Long, Data>(size);
        ArrayList<CollectionItem> list = new ArrayList<CollectionItem>(size);
        for (Data value : valueList) {
            long itemId = this.nextId();
            list.add(new CollectionItem(itemId, value));
            map.put(itemId, value);
        }
        this.getCollection().addAll(list);
        return map;
    }

    protected void addAllBackup(Map<Long, Data> valueMap) {
        HashMap<Long, CollectionItem> map = new HashMap<Long, CollectionItem>(valueMap.size());
        for (Map.Entry entry : map.entrySet()) {
            long itemId = (Long)entry.getKey();
            map.put(itemId, new CollectionItem(itemId, entry.getValue()));
        }
        this.getMap().putAll(map);
    }

    protected Map<Long, Data> compareAndRemove(boolean retain, Set<Data> valueSet) {
        HashMap<Long, Data> itemIdMap = new HashMap<Long, Data>();
        Iterator<CollectionItem> iterator = this.getCollection().iterator();
        while (iterator.hasNext()) {
            CollectionItem item = iterator.next();
            boolean contains = valueSet.contains(item.getValue());
            if ((!contains || retain) && (contains || !retain)) continue;
            itemIdMap.put(item.getItemId(), (Data)item.getValue());
            iterator.remove();
        }
        return itemIdMap;
    }

    protected Collection<Data> getAll() {
        ArrayList<Data> sub = new ArrayList<Data>(this.getCollection().size());
        for (CollectionItem item : this.getCollection()) {
            sub.add((Data)item.getValue());
        }
        return sub;
    }

    protected boolean hasEnoughCapacity(int delta) {
        return this.getCollection().size() + delta <= this.getConfig().getMaxSize();
    }

    public long reserveAdd(String transactionId) {
        long itemId = this.nextId();
        this.txMap.put(itemId, new TxCollectionItem(itemId, null, transactionId, false));
        return itemId;
    }

    public void reserveAddBackup(long itemId, String transactionId) {
        TxCollectionItem item = new TxCollectionItem(itemId, null, transactionId, false);
        TxCollectionItem o = this.txMap.put(itemId, item);
        if (o != null) {
            this.logger.severe("txnOfferBackupReserve operation-> Item exists already at txMap for itemId: " + itemId);
        }
    }

    public CollectionItem reserveRemove(long reservedItemId, Data value, String transactionId) {
        Iterator<CollectionItem> iterator = this.getCollection().iterator();
        while (iterator.hasNext()) {
            CollectionItem item = iterator.next();
            if (!value.equals(item.getValue())) continue;
            iterator.remove();
            this.txMap.put(item.getItemId(), new TxCollectionItem(item).setTransactionId(transactionId).setRemoveOperation(true));
            return item;
        }
        if (reservedItemId != -1L) {
            return this.txMap.remove(reservedItemId);
        }
        return null;
    }

    public void reserveRemoveBackup(long itemId, String transactionId) {
        CollectionItem item = this.getMap().remove(itemId);
        if (item == null) {
            throw new TransactionException("Backup reserve failed: " + itemId);
        }
        this.txMap.put(itemId, new TxCollectionItem(item).setTransactionId(transactionId).setRemoveOperation(true));
    }

    public void ensureReserve(long itemId) {
        if (this.txMap.get(itemId) == null) {
            throw new TransactionException("No reserve for itemId: " + itemId);
        }
    }

    public void rollbackAdd(long itemId) {
        if (this.txMap.remove(itemId) == null) {
            this.logger.warning("rollbackAdd operation-> No txn item for itemId: " + itemId);
        }
    }

    public void rollbackAddBackup(long itemId) {
        if (this.txMap.remove(itemId) == null) {
            this.logger.warning("rollbackAddBackup operation-> No txn item for itemId: " + itemId);
        }
    }

    public void rollbackRemove(long itemId) {
        CollectionItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.warning("rollbackRemove No txn item for itemId: " + itemId);
        }
        this.getCollection().add(item);
    }

    public void rollbackRemoveBackup(long itemId) {
        CollectionItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.warning("rollbackRemoveBackup No txn item for itemId: " + itemId);
        }
    }

    public void commitAdd(long itemId, Data value) {
        CollectionItem item = this.txMap.remove(itemId);
        if (item == null) {
            throw new TransactionException("No reserve :" + itemId);
        }
        item.setValue(value);
        this.getCollection().add(item);
    }

    public void commitAddBackup(long itemId, Data value) {
        CollectionItem item = this.txMap.remove(itemId);
        if (item == null) {
            item = new CollectionItem(itemId, value);
        }
        this.getMap().put(itemId, item);
    }

    public CollectionItem commitRemove(long itemId) {
        CollectionItem item = this.txMap.remove(itemId);
        if (item == null) {
            this.logger.warning("commitRemove operation-> No txn item for itemId: " + itemId);
        }
        return item;
    }

    public void commitRemoveBackup(long itemId) {
        if (this.txMap.remove(itemId) == null) {
            this.logger.warning("commitRemoveBackup operation-> No txn item for itemId: " + itemId);
        }
    }

    public void rollbackTransaction(String transactionId) {
        Iterator<TxCollectionItem> iterator = this.txMap.values().iterator();
        while (iterator.hasNext()) {
            TxCollectionItem item = iterator.next();
            if (!transactionId.equals(item.getTransactionId())) continue;
            iterator.remove();
            if (!item.isRemoveOperation()) continue;
            this.getCollection().add(item);
        }
    }

    public long nextId() {
        return this.idGenerator++;
    }

    void setId(long itemId) {
        this.idGenerator = Math.max(itemId + 1L, this.idGenerator);
    }

    public void destroy() {
        this.onDestroy();
        if (this.itemMap != null) {
            this.itemMap.clear();
        }
        this.txMap.clear();
    }

    protected abstract void onDestroy();

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        Collection<CollectionItem> collection = this.getCollection();
        out.writeInt(collection.size());
        for (CollectionItem item : collection) {
            item.writeData(out);
        }
        out.writeInt(this.txMap.size());
        for (TxCollectionItem txCollectionItem : this.txMap.values()) {
            txCollectionItem.writeData(out);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        int collectionSize = in.readInt();
        Collection<CollectionItem> collection = this.getCollection();
        for (int i = 0; i < collectionSize; ++i) {
            CollectionItem item = new CollectionItem();
            item.readData(in);
            collection.add(item);
            this.setId(item.getItemId());
        }
        int txMapSize = in.readInt();
        for (int i = 0; i < txMapSize; ++i) {
            TxCollectionItem txCollectionItem = new TxCollectionItem();
            txCollectionItem.readData(in);
            this.txMap.put(txCollectionItem.getItemId(), txCollectionItem);
            this.setId(txCollectionItem.itemId);
        }
    }
}

