/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework.launch;

import java.lang.reflect.Array;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerList {
    private final List<Element<?>> elements = new LinkedList();

    public synchronized <T extends EventListener> boolean add(Bundle bundle, Class<T> clazz, T t) {
        if (bundle == null) {
            throw new NullPointerException("bundle");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (t == null) {
            throw new NullPointerException("listener");
        }
        int n = this.indexOf(bundle, clazz, t);
        if (n == -1) {
            return this.elements.add(new Element<T>(bundle, clazz, t));
        }
        return false;
    }

    public synchronized <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray = new EventListener[this.elements.size()];
        int n = 0;
        for (Element<?> element : this.elements) {
            if (element.clazz != clazz) continue;
            eventListenerArray[n++] = element.listener;
        }
        EventListener[] eventListenerArray2 = (EventListener[])Array.newInstance(clazz, n);
        System.arraycopy(eventListenerArray, 0, eventListenerArray2, 0, n);
        return eventListenerArray2;
    }

    private synchronized <T extends EventListener> int indexOf(Bundle bundle, Class<T> clazz, T t) {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            Element<?> element = this.elements.get(i);
            if (!element.bundle.equals(bundle) || element.clazz != clazz || element.listener != t) continue;
            return i;
        }
        return -1;
    }

    public synchronized <T extends EventListener> boolean remove(Bundle bundle, Class<T> clazz, T t) {
        int n = this.indexOf(bundle, clazz, t);
        if (n == -1) {
            return false;
        }
        this.elements.remove(n);
        return true;
    }

    public synchronized boolean removeAll(Bundle bundle) {
        boolean bl = false;
        int n = 0;
        int n2 = this.elements.size();
        while (n < n2) {
            if (this.elements.get((int)n).bundle.equals(bundle) && this.elements.remove(n) != null) {
                bl = true;
                continue;
            }
            ++n;
        }
        return bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Element<T extends EventListener> {
        public final Bundle bundle;
        public final Class<T> clazz;
        public final T listener;

        public Element(Bundle bundle, Class<T> clazz, T t) {
            this.bundle = bundle;
            this.clazz = clazz;
            this.listener = t;
        }
    }
}

