/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.format.MediaFormat;

public class DynamicPayloadTypeRegistry {
    private static final Logger logger = Logger.getLogger(DynamicPayloadTypeRegistry.class);
    private byte nextDynamicPayloadType = (byte)96;
    private final Map<MediaFormat, Byte> payloadTypeMappings = new HashMap<MediaFormat, Byte>();
    private final Map<Byte, Byte> payloadTypeOverrides = new HashMap<Byte, Byte>();
    private Map<Byte, String> localPayloadTypePreferences = null;
    private Map<MediaFormat, Byte> mediaMappings = null;

    public void setLocalPayloadTypePreferences(Map<Byte, String> mappings) {
        this.localPayloadTypePreferences = mappings;
    }

    public byte obtainPayloadTypeNumber(MediaFormat format) throws IllegalStateException {
        Byte payloadType = this.getPayloadType(format);
        if (payloadType == null) {
            Byte preferredPT = this.getPreferredDynamicPayloadType(format);
            payloadType = preferredPT != null && this.findFormat(preferredPT) == null ? preferredPT : Byte.valueOf(this.nextPayloadTypeNumber());
            this.payloadTypeMappings.put(format, payloadType);
        }
        return payloadType;
    }

    private Map<MediaFormat, Byte> getDynamicPayloadTypePreferences() {
        if (this.mediaMappings == null) {
            HashMap<MediaFormat, Byte> mappings = new HashMap<MediaFormat, Byte>(ProtocolMediaActivator.getMediaService().getDynamicPayloadTypePreferences());
            if (this.localPayloadTypePreferences == null) {
                return mappings;
            }
            for (Map.Entry<Byte, String> e : this.localPayloadTypePreferences.entrySet()) {
                Byte key = e.getKey();
                String fmt = e.getValue();
                MediaFormat saveFmt = null;
                Byte saveKey = null;
                Byte replaceKey = null;
                MediaFormat replaceFmt = null;
                for (Map.Entry e2 : mappings.entrySet()) {
                    MediaFormat fmt2 = (MediaFormat)e2.getKey();
                    Byte key2 = (Byte)e2.getValue();
                    if (fmt2.getEncoding().equals(fmt)) {
                        saveFmt = fmt2;
                        saveKey = key2;
                        if (replaceKey != null) break;
                    }
                    if (!key2.equals(key)) continue;
                    replaceFmt = fmt2;
                    replaceKey = key;
                    if (saveKey != null) break;
                }
                if (saveFmt == null) continue;
                mappings.remove(saveFmt);
                if (replaceFmt != null) {
                    mappings.remove(replaceFmt);
                }
                mappings.put(saveFmt, key);
                if (replaceFmt == null) continue;
                mappings.put(replaceFmt, saveKey);
            }
            this.mediaMappings = mappings;
        }
        return this.mediaMappings;
    }

    private Byte getPreferredDynamicPayloadType(MediaFormat format) {
        Map<MediaFormat, Byte> ptPreferences = this.getDynamicPayloadTypePreferences();
        return DynamicPayloadTypeRegistry.getPayloadTypeFromMap(ptPreferences, format);
    }

    public void addMapping(MediaFormat format, byte payloadType) throws IllegalArgumentException {
        MediaFormat alreadyMappedFmt = this.findFormat(payloadType);
        if (alreadyMappedFmt != null) {
            if (alreadyMappedFmt.matches(format)) {
                this.payloadTypeOverrides.remove(payloadType);
                return;
            }
            byte newlyObtainedPT = this.obtainPayloadTypeNumber(format);
            logger.warn((Object)("Remote party is trying to remap payload type " + payloadType + " and reassign it from " + alreadyMappedFmt + " to " + format + ". We'll go along but there might be issues because" + " of this. We'll also expect to receive " + format + " with PT=" + newlyObtainedPT));
        }
        if (payloadType < 96) {
            throw new IllegalArgumentException(String.valueOf(payloadType) + " is not a valid dynamic payload type number." + " (must be between " + 96 + " and " + 127);
        }
        Byte originalPayloadType = this.getPayloadType(format);
        if (originalPayloadType != null && originalPayloadType != payloadType) {
            this.payloadTypeOverrides.put(originalPayloadType, payloadType);
        } else {
            this.payloadTypeMappings.put(format, payloadType);
        }
    }

    public MediaFormat findFormat(byte payloadType) {
        for (Map.Entry<MediaFormat, Byte> entry : this.payloadTypeMappings.entrySet()) {
            byte fmtPayloadType = entry.getValue();
            if (fmtPayloadType != payloadType) continue;
            return entry.getKey();
        }
        return null;
    }

    private byte nextPayloadTypeNumber() throws IllegalStateException {
        byte payloadType;
        do {
            if (this.nextDynamicPayloadType < 0) {
                throw new IllegalStateException("Impossible to allocate more than the already 32 mapped dynamic payload type numbers");
            }
            this.nextDynamicPayloadType = (byte)(this.nextDynamicPayloadType + 1);
        } while (this.findFormat(payloadType) != null || this.findFormatWithPreference(payloadType) != null);
        return payloadType;
    }

    private MediaFormat findFormatWithPreference(byte payloadTypePreference) {
        for (Map.Entry<MediaFormat, Byte> entry : this.getDynamicPayloadTypePreferences().entrySet()) {
            Byte value = entry.getValue();
            if (value == null || value != payloadTypePreference) continue;
            return entry.getKey();
        }
        return null;
    }

    public Map<MediaFormat, Byte> getMappings() {
        return new HashMap<MediaFormat, Byte>(this.payloadTypeMappings);
    }

    public Map<Byte, Byte> getMappingOverrides() {
        return new HashMap<Byte, Byte>(this.payloadTypeOverrides);
    }

    public Byte getPayloadType(MediaFormat format) {
        return DynamicPayloadTypeRegistry.getPayloadTypeFromMap(this.payloadTypeMappings, format);
    }

    private static Byte getPayloadTypeFromMap(Map<MediaFormat, Byte> formatMap, MediaFormat format) {
        for (Map.Entry<MediaFormat, Byte> mapping : formatMap.entrySet()) {
            if (!mapping.getKey().matches(format)) continue;
            return mapping.getValue();
        }
        return null;
    }
}

