/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.ZrtpControl;

public abstract class SecurityAccountRegistration
implements Serializable {
    public static final List<String> ENCRYPTION_PROTOCOLS = Collections.unmodifiableList(Arrays.asList(ZrtpControl.PROTO_NAME, SDesControl.PROTO_NAME, DtlsControl.PROTO_NAME));
    private boolean defaultEncryption = true;
    private boolean sipZrtpAttribute = true;
    private boolean sdesEnabled = false;
    private String sdesCipherSuites = null;
    private Map<String, Integer> encryptionProtocols = new HashMap<String, Integer>(1);
    private Map<String, Boolean> encryptionProtocolStatus;

    public SecurityAccountRegistration() {
        this.encryptionProtocols.put("ZRTP", 0);
        this.encryptionProtocolStatus = new HashMap<String, Boolean>(1);
        this.encryptionProtocolStatus.put("ZRTP", true);
        this.sdesCipherSuites = UtilActivator.getResources().getSettingsString("net.java.sip.communicator.service.neomedia.SDES_CIPHER_SUITES");
    }

    public boolean isDefaultEncryption() {
        return this.defaultEncryption;
    }

    public void setDefaultEncryption(boolean defaultEncryption) {
        this.defaultEncryption = defaultEncryption;
    }

    public boolean isSipZrtpAttribute() {
        return this.sipZrtpAttribute;
    }

    public void setSipZrtpAttribute(boolean sipZrtpAttribute) {
        this.sipZrtpAttribute = sipZrtpAttribute;
    }

    public boolean isSDesEnabled() {
        return this.sdesEnabled;
    }

    public void setSDesEnabled(boolean sdesEnabled) {
        this.sdesEnabled = sdesEnabled;
    }

    public String getSDesCipherSuites() {
        return this.sdesCipherSuites;
    }

    public void setSDesCipherSuites(String cipherSuites) {
        this.sdesCipherSuites = cipherSuites;
    }

    public abstract void setSavpOption(int var1);

    public abstract int getSavpOption();

    public Map<String, Integer> getEncryptionProtocols() {
        return this.encryptionProtocols;
    }

    public void setEncryptionProtocols(Map<String, Integer> encryptionProtocols) {
        this.encryptionProtocols = encryptionProtocols;
    }

    public Map<String, Boolean> getEncryptionProtocolStatus() {
        return this.encryptionProtocolStatus;
    }

    public void setEncryptionProtocolStatus(Map<String, Boolean> encryptionProtocolStatus) {
        this.encryptionProtocolStatus = encryptionProtocolStatus;
    }

    private void addEncryptionProtocolsToProperties(Map<String, String> properties) {
        for (Map.Entry<String, Integer> e : this.getEncryptionProtocols().entrySet()) {
            properties.put("ENCRYPTION_PROTOCOL." + e.getKey(), e.getValue().toString());
        }
    }

    private void addEncryptionProtocolStatusToProperties(Map<String, String> properties) {
        for (Map.Entry<String, Boolean> e : this.getEncryptionProtocolStatus().entrySet()) {
            properties.put("ENCRYPTION_PROTOCOL_STATUS." + e.getKey(), e.getValue().toString());
        }
    }

    public void storeProperties(Map<String, String> propertiesMap) {
        propertiesMap.put("DEFAULT_ENCRYPTION", Boolean.toString(this.isDefaultEncryption()));
        this.addEncryptionProtocolsToProperties(propertiesMap);
        this.addEncryptionProtocolStatusToProperties(propertiesMap);
        propertiesMap.put("DEFAULT_SIPZRTP_ATTRIBUTE", Boolean.toString(this.isSipZrtpAttribute()));
        propertiesMap.put("SAVP_OPTION", Integer.toString(this.getSavpOption()));
        propertiesMap.put("SDES_CIPHER_SUITES", this.getSDesCipherSuites());
    }

    public void loadAccount(AccountID accountID) {
        this.setDefaultEncryption(accountID.getAccountPropertyBoolean("DEFAULT_ENCRYPTION", true));
        this.encryptionProtocols = new HashMap<String, Integer>();
        this.encryptionProtocolStatus = new HashMap<String, Boolean>();
        Map<String, Integer> srcEncryptionProtocols = accountID.getIntegerPropertiesByPrefix("ENCRYPTION_PROTOCOL", true);
        Map<String, Boolean> srcEncryptionProtocolStatus = accountID.getBooleanPropertiesByPrefix("ENCRYPTION_PROTOCOL_STATUS", true, false);
        int prefixeLength = "ENCRYPTION_PROTOCOL".length() + 1;
        for (Map.Entry<String, Integer> e : srcEncryptionProtocols.entrySet()) {
            String name = e.getKey().substring(prefixeLength);
            if (!SecurityAccountRegistration.isExistingEncryptionProtocol(name)) continue;
            this.encryptionProtocols.put(name, e.getValue());
            boolean enabled = srcEncryptionProtocolStatus.get("ENCRYPTION_PROTOCOL_STATUS." + name);
            this.encryptionProtocolStatus.put(name, enabled);
        }
        this.setSipZrtpAttribute(accountID.getAccountPropertyBoolean("DEFAULT_SIPZRTP_ATTRIBUTE", true));
        this.setSavpOption(accountID.getAccountPropertyInt("SAVP_OPTION", 0));
        this.setSDesCipherSuites(accountID.getAccountPropertyString("SDES_CIPHER_SUITES"));
    }

    public static Object[] loadEncryptionProtocols(Map<String, Integer> encryptionProtocols, Map<String, Boolean> encryptionProtocolStatus) {
        int nbEncryptionProtocols = ENCRYPTION_PROTOCOLS.size();
        String[] encryptions = new String[nbEncryptionProtocols];
        boolean[] selectedEncryptions = new boolean[nbEncryptionProtocols];
        for (Map.Entry<String, Integer> e : encryptionProtocols.entrySet()) {
            String name;
            int index = e.getValue();
            if (index == -1 || !SecurityAccountRegistration.isExistingEncryptionProtocol(name = e.getKey())) continue;
            encryptions[index] = name;
            selectedEncryptions[index] = encryptionProtocolStatus.get(name);
        }
        int j = 0;
        for (String encryptionProtocol : ENCRYPTION_PROTOCOLS) {
            if (encryptionProtocols.containsKey(encryptionProtocol)) continue;
            boolean set = false;
            while (j < encryptions.length && !set) {
                if (encryptions[j] == null) {
                    encryptions[j] = encryptionProtocol;
                    selectedEncryptions[j] = encryptionProtocol.equals("ZRTP");
                    set = true;
                }
                ++j;
            }
        }
        return new Object[]{encryptions, selectedEncryptions};
    }

    private static boolean isExistingEncryptionProtocol(String protocol) {
        return ENCRYPTION_PROTOCOLS.contains(protocol);
    }
}

