/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer.audio;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.FileTypeDescriptor;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import net.sf.fmj.media.codec.JavaSoundCodec;
import net.sf.fmj.media.multiplexer.AbstractInputStreamMux;
import net.sf.fmj.media.multiplexer.InputStreamPushDataSource;
import net.sf.fmj.media.multiplexer.InputStreamPushSourceStream;
import net.sf.fmj.media.renderer.audio.JavaSoundUtils;
import net.sf.fmj.utility.LoggerSingleton;

public class AUMux
extends AbstractInputStreamMux {
    private static final Logger logger = LoggerSingleton.logger;
    private boolean headerWritten = false;
    private boolean trailerWritten = false;
    private long bytesWritten;

    public AUMux() {
        super(new FileTypeDescriptor("audio.basic"));
    }

    public void close() {
        if (!this.trailerWritten) {
            try {
                this.outputTrailer(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
            this.trailerWritten = true;
        }
        super.close();
    }

    protected void doProcess(Buffer buffer, int trackID, OutputStream os) throws IOException {
        if (!this.headerWritten) {
            this.outputHeader(os);
            this.headerWritten = true;
        }
        if (buffer.isEOM()) {
            if (!this.trailerWritten) {
                this.outputTrailer(os);
                this.trailerWritten = true;
            }
            os.close();
            return;
        }
        if (buffer.isDiscard()) {
            return;
        }
        os.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
        this.bytesWritten += (long)buffer.getLength();
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat("LINEAR", -1.0, 8, -1, -1, 1), new AudioFormat("LINEAR", -1.0, 16, -1, 1, 1), new AudioFormat("LINEAR", -1.0, 24, -1, 1, 1), new AudioFormat("LINEAR", -1.0, 32, -1, 1, 1), new AudioFormat("ULAW"), new AudioFormat("alaw")};
    }

    public void open() throws ResourceUnavailableException {
        super.open();
        if (!this.headerWritten) {
            try {
                this.outputHeader(this.getOutputStream());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new ResourceUnavailableException("" + e);
            }
            this.headerWritten = true;
        }
    }

    private void outputHeader(OutputStream os) throws IOException {
        byte[] header = JavaSoundCodec.createAuHeader(JavaSoundUtils.convertFormat((AudioFormat)this.inputFormats[0]));
        if (header == null) {
            throw new IOException("Unable to create AU header");
        }
        os.write(header);
    }

    private void outputTrailer(OutputStream os) throws IOException {
        InputStreamPushSourceStream ispss;
        InputStreamPushDataSource pds;
        PushSourceStream pss;
        DataSource ds = this.getDataOutput();
        if (ds instanceof InputStreamPushDataSource && (pss = (pds = (InputStreamPushDataSource)ds).getStreams()[0]) instanceof InputStreamPushSourceStream && (Seekable)((Object)(ispss = (InputStreamPushSourceStream)pss).getTransferHandler()) instanceof Seekable) {
            ((Seekable)((Object)ispss.getTransferHandler())).seek(8L);
            this.writeInt(os, this.bytesWritten);
            if (this.getDataOutputNoInit() != null) {
                this.getDataOutputNoInit().notifyDataAvailable(0);
            }
        }
    }

    public Format setInputFormat(Format format, int trackID) {
        logger.finer("setInputFormat " + format + " " + trackID);
        boolean match = false;
        for (Format supported : this.getSupportedInputFormats()) {
            if (!format.matches(supported)) continue;
            match = true;
            break;
        }
        if (!match) {
            logger.warning("Input format does not match any supported input format: " + format);
            return null;
        }
        if (this.inputFormats != null) {
            this.inputFormats[trackID] = format;
        }
        return format;
    }
}

