/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.multiplexer;

import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.BasicClock;
import net.sf.fmj.media.BasicPlugIn;
import net.sf.fmj.media.CircularBuffer;
import net.sf.fmj.media.MediaTimeBase;
import net.sf.fmj.media.control.MonitorAdapter;
import net.sf.fmj.media.protocol.BasicPushBufferDataSource;
import net.sf.fmj.media.protocol.BasicSourceStream;
import net.sf.fmj.media.util.MediaThread;

public class RawBufferMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected ContentDescriptor[] supported = null;
    protected ContentDescriptor contentDesc = null;
    protected RawBufferDataSource source = null;
    protected RawBufferSourceStream[] streams = null;
    protected BasicClock clock = null;
    protected RawMuxTimeBase timeBase = null;
    protected long[] mediaTime;
    protected int masterTrackID = -1;
    boolean sourceDisconnected = false;
    boolean allowDrop = false;
    boolean hasRead = false;
    protected int numTracks = 0;
    protected Format[] trackFormats;
    protected MonitorAdapter[] mc = null;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = -1L;
    long mediaStartTime = -1L;

    public RawBufferMux() {
        this.supported = new ContentDescriptor[1];
        this.supported[0] = new ContentDescriptor("raw");
        this.timeBase = new RawMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.source != null) {
            try {
                this.source.stop();
                this.source.disconnect();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.source = null;
        }
        for (int i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.mc[i].close();
        }
    }

    public DataSource getDataOutput() {
        return this.source;
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public String getName() {
        return "Raw Buffer Multiplexer";
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new AudioFormat(null), new VideoFormat(null)};
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] fmt) {
        return this.supported;
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public boolean initializeTracks(Format[] trackFormats) {
        if (this.source.getStreams() != null) {
            throw new Error("initializeTracks has been called previously. ");
        }
        this.source.initialize(trackFormats);
        this.streams = (RawBufferSourceStream[])this.source.getStreams();
        return true;
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    public void open() throws ResourceUnavailableException {
        int i;
        this.initializeTracks(this.trackFormats);
        if (this.source == null || this.source.getStreams() == null) {
            throw new ResourceUnavailableException("DataSource and SourceStreams were not created succesfully.");
        }
        try {
            this.source.connect();
        }
        catch (IOException e) {
            throw new ResourceUnavailableException(e.getMessage());
        }
        int len = 0;
        this.mediaTime = new long[this.trackFormats.length];
        this.mc = new MonitorAdapter[this.trackFormats.length];
        for (i = 0; i < this.trackFormats.length; ++i) {
            this.mediaTime[i] = 0L;
            if (!(this.trackFormats[i] instanceof VideoFormat) && !(this.trackFormats[i] instanceof AudioFormat)) continue;
            this.mc[i] = new MonitorAdapter(this.trackFormats[i], this);
            if (this.mc[i] == null) continue;
            ++len;
        }
        int j = 0;
        this.controls = new Control[len];
        for (i = 0; i < this.mc.length; ++i) {
            if (this.mc[i] == null) continue;
            this.controls[j++] = this.mc[i];
        }
    }

    public int process(Buffer buffer, int trackID) {
        if ((buffer.getFlags() & 0x1000) != 0) {
            buffer.setFlags(buffer.getFlags() & 0xFFFFEFFF | 0x100);
        }
        if (this.mc[trackID] != null && this.mc[trackID].isEnabled()) {
            this.mc[trackID].process(buffer);
        }
        if (this.streams == null || buffer == null || trackID >= this.streams.length) {
            return 1;
        }
        this.updateTime(buffer, trackID);
        return this.streams[trackID].process(buffer);
    }

    public void reset() {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].reset();
            if (this.mc[i] == null) continue;
            this.mc[i].reset();
        }
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor outputContentDescriptor) {
        if (RawBufferMux.matches(outputContentDescriptor, this.supported) == null) {
            return null;
        }
        this.contentDesc = outputContentDescriptor;
        this.source = new RawBufferDataSource();
        return this.contentDesc;
    }

    public Format setInputFormat(Format input, int trackID) {
        if (trackID < this.numTracks) {
            this.trackFormats[trackID] = input;
        }
        for (int i = 0; i < this.numTracks; ++i) {
            if (this.trackFormats[i] != null) continue;
            return input;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMediaTime(Time now) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(now);
            for (int i = 0; i < this.mediaTime.length; ++i) {
                this.mediaTime[i] = now.getNanoseconds();
            }
            this.timeBase.update();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = now.getNanoseconds() / 1000000L;
        }
    }

    public int setNumTracks(int nTracks) {
        this.numTracks = nTracks;
        this.trackFormats = new Format[nTracks];
        for (int i = 0; i < nTracks; ++i) {
            this.trackFormats[i] = null;
        }
        return nTracks;
    }

    public float setRate(float factor) {
        if (factor == this.clock.getRate()) {
            return factor;
        }
        return this.clock.setRate(1.0f);
    }

    public void setStopTime(Time stopTime) {
        this.clock.setStopTime(stopTime);
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (master != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncStart(Time at) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.clock.syncStart(at);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis();
            this.mediaStartTime = this.getMediaNanoseconds() / 1000000L;
        }
    }

    protected void updateTime(Buffer buf, int trackID) {
        if (buf.getFormat() instanceof AudioFormat) {
            if (mpegAudio.matches(buf.getFormat())) {
                if (buf.getTimeStamp() < 0L) {
                    if (this.systemStartTime >= 0L) {
                        this.mediaTime[trackID] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
                    }
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            } else {
                long t = ((AudioFormat)buf.getFormat()).computeDuration(buf.getLength());
                if (t >= 0L) {
                    int n = trackID;
                    this.mediaTime[n] = this.mediaTime[n] + t;
                } else {
                    this.mediaTime[trackID] = buf.getTimeStamp();
                }
            }
        } else if (buf.getTimeStamp() < 0L) {
            if (this.systemStartTime >= 0L) {
                this.mediaTime[trackID] = (this.mediaStartTime + System.currentTimeMillis() - this.systemStartTime) * 1000000L;
            }
        } else {
            this.mediaTime[trackID] = buf.getTimeStamp();
        }
        this.timeBase.update();
    }

    class RawMuxTimeBase
    extends MediaTimeBase {
        long ticks = 0L;
        boolean updated = false;

        RawMuxTimeBase() {
        }

        public long getMediaTime() {
            if (RawBufferMux.this.masterTrackID >= 0) {
                return RawBufferMux.this.mediaTime[RawBufferMux.this.masterTrackID];
            }
            if (!this.updated) {
                return this.ticks;
            }
            if (RawBufferMux.this.mediaTime.length == 1) {
                this.ticks = RawBufferMux.this.mediaTime[0];
            } else {
                this.ticks = RawBufferMux.this.mediaTime[0];
                for (int i = 1; i < RawBufferMux.this.mediaTime.length; ++i) {
                    if (RawBufferMux.this.mediaTime[i] >= this.ticks) continue;
                    this.ticks = RawBufferMux.this.mediaTime[i];
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }
    }

    class RawBufferSourceStream
    extends BasicSourceStream
    implements PushBufferStream,
    Runnable {
        Format format = null;
        CircularBuffer bufferQ;
        boolean started = false;
        Object startReq = new Integer(0);
        BufferTransferHandler handler = null;
        Thread streamThread = null;
        boolean closed = false;
        boolean draining = false;
        Object drainSync = new Object();

        public RawBufferSourceStream(Format fmt) {
            this.contentDescriptor = RawBufferMux.this.contentDesc;
            this.format = fmt;
            this.bufferQ = new CircularBuffer(5);
            this.streamThread = new MediaThread(this, "RawBufferStream Thread");
            if (this.streamThread != null) {
                this.streamThread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            this.closed = true;
            if (this.streamThread != null) {
                try {
                    this.reset();
                    Object object = this.startReq;
                    synchronized (object) {
                        this.startReq.notifyAll();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Format getFormat() {
            return this.format;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int process(Buffer filled) {
            Buffer buffer;
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                Buffer tmp;
                if (RawBufferMux.this.allowDrop && !this.bufferQ.canWrite() && this.bufferQ.canRead() && ((tmp = this.bufferQ.peek()).getFlags() & 0x20) == 0) {
                    this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                while (!this.bufferQ.canWrite() && !this.closed) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e) {}
                }
                if (this.closed) {
                    return 0;
                }
                buffer = this.bufferQ.getEmptyBuffer();
            }
            Object bdata = buffer.getData();
            Object bheader = buffer.getHeader();
            buffer.setData(filled.getData());
            buffer.setHeader(filled.getHeader());
            filled.setData(bdata);
            filled.setHeader(bheader);
            buffer.setLength(filled.getLength());
            buffer.setEOM(filled.isEOM());
            buffer.setFlags(filled.getFlags());
            buffer.setTimeStamp(filled.getTimeStamp());
            buffer.setFormat(filled.getFormat());
            buffer.setOffset(filled.getOffset());
            buffer.setSequenceNumber(filled.getSequenceNumber());
            if (filled.isEOM()) {
                this.draining = true;
            }
            Object object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.writeReport();
                this.bufferQ.notifyAll();
            }
            if (filled.isEOM()) {
                object = this.drainSync;
                synchronized (object) {
                    try {
                        if (this.draining) {
                            this.drainSync.wait(3000L);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read(Buffer buffer) throws IOException {
            if (this.closed) {
                throw new IOException("The source stream is closed");
            }
            Buffer current = null;
            Object object = this.bufferQ;
            synchronized (object) {
                while (!this.bufferQ.canRead()) {
                    try {
                        this.bufferQ.wait();
                    }
                    catch (Exception e) {}
                }
                current = this.bufferQ.read();
            }
            if (current.isEOM()) {
                object = this.drainSync;
                synchronized (object) {
                    if (this.draining) {
                        this.draining = false;
                        this.drainSync.notifyAll();
                    }
                }
            }
            Object data = buffer.getData();
            Object hdr = buffer.getHeader();
            buffer.copy(current);
            current.setData(data);
            current.setHeader(hdr);
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.readReport();
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset() {
            Object object = this.bufferQ;
            synchronized (object) {
                while (this.bufferQ.canRead()) {
                    Buffer b = this.bufferQ.read();
                    this.bufferQ.readReport();
                }
                this.bufferQ.notifyAll();
            }
            object = this.drainSync;
            synchronized (object) {
                if (this.draining) {
                    this.draining = false;
                    this.drainSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!this.started && !this.closed) {
                            this.startReq.wait();
                        }
                    }
                    object = this.bufferQ;
                    synchronized (object) {
                        do {
                            if (!RawBufferMux.this.hasRead) {
                                this.bufferQ.wait(250L);
                            }
                            RawBufferMux.this.hasRead = false;
                        } while (!this.bufferQ.canRead() && !this.closed && this.started);
                    }
                    if (this.closed) {
                        return;
                    }
                    if (!this.started || this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException e) {
                System.err.println("Thread " + e.getMessage());
                return;
            }
        }

        public void setTransferHandler(BufferTransferHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void start() {
            Object object = this.startReq;
            synchronized (object) {
                if (this.started) {
                    return;
                }
                this.started = true;
                this.startReq.notifyAll();
            }
            object = this.bufferQ;
            synchronized (object) {
                RawBufferMux.this.hasRead = true;
                this.bufferQ.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stop() {
            Object object = this.startReq;
            synchronized (object) {
                this.started = false;
            }
            object = this.bufferQ;
            synchronized (object) {
                this.bufferQ.notifyAll();
            }
        }
    }

    class RawBufferDataSource
    extends BasicPushBufferDataSource {
        public RawBufferDataSource() {
            if (RawBufferMux.this.contentDesc == null) {
                return;
            }
            this.contentType = RawBufferMux.this.contentDesc.getContentType();
        }

        public void connect() throws IOException {
            super.connect();
            RawBufferMux.this.sourceDisconnected = false;
        }

        public void disconnect() {
            super.disconnect();
            RawBufferMux.this.sourceDisconnected = true;
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].stop();
                RawBufferMux.this.streams[i].close();
            }
        }

        public PushBufferStream[] getStreams() {
            return RawBufferMux.this.streams;
        }

        private void initialize(Format[] trackFormats) {
            RawBufferMux.this.streams = new RawBufferSourceStream[trackFormats.length];
            for (int i = 0; i < trackFormats.length; ++i) {
                RawBufferMux.this.streams[i] = new RawBufferSourceStream(trackFormats[i]);
            }
        }

        public void start() throws IOException {
            super.start();
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].start();
            }
        }

        public void stop() throws IOException {
            super.stop();
            for (int i = 0; i < RawBufferMux.this.streams.length; ++i) {
                RawBufferMux.this.streams[i].stop();
            }
        }
    }
}

