/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import net.java.sip.communicator.util.FileHandler;

public class Logger {
    private final java.util.logging.Logger loggerDelegate;

    private Logger(java.util.logging.Logger logger) {
        this.loggerDelegate = logger;
    }

    public static Logger getLogger(Class<?> clazz) throws NullPointerException {
        return Logger.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) throws NullPointerException {
        return new Logger(java.util.logging.Logger.getLogger(name));
    }

    public void logEntry() {
        if (this.loggerDelegate.isLoggable(Level.FINEST)) {
            StackTraceElement caller = new Throwable().getStackTrace()[1];
            this.loggerDelegate.log(Level.FINEST, "[entry] " + caller.getMethodName());
        }
    }

    public void logExit() {
        if (this.loggerDelegate.isLoggable(Level.FINEST)) {
            StackTraceElement caller = new Throwable().getStackTrace()[1];
            this.loggerDelegate.log(Level.FINEST, "[exit] " + caller.getMethodName());
        }
    }

    public boolean isTraceEnabled() {
        return this.loggerDelegate.isLoggable(Level.FINER);
    }

    public void trace(Object msg) {
        this.loggerDelegate.finer(msg != null ? msg.toString() : "null");
    }

    public void trace(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.FINER, msg != null ? msg.toString() : "null", t);
    }

    public boolean isDebugEnabled() {
        return this.loggerDelegate.isLoggable(Level.FINE);
    }

    public void debug(Object msg) {
        this.loggerDelegate.fine(msg != null ? msg.toString() : "null");
    }

    public void debug(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.FINE, msg != null ? msg.toString() : "null", t);
    }

    public boolean isInfoEnabled() {
        return this.loggerDelegate.isLoggable(Level.INFO);
    }

    public void info(Object msg) {
        this.loggerDelegate.info(msg != null ? msg.toString() : "null");
    }

    public void info(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.INFO, msg != null ? msg.toString() : "null", t);
    }

    public void warn(Object msg) {
        this.loggerDelegate.warning(msg != null ? msg.toString() : "null");
    }

    public void warn(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.WARNING, msg != null ? msg.toString() : "null", t);
    }

    public void error(Object msg) {
        this.loggerDelegate.severe(msg != null ? msg.toString() : "null");
    }

    public void error(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.SEVERE, msg != null ? msg.toString() : "null", t);
    }

    public void fatal(Object msg) {
        this.loggerDelegate.severe(msg != null ? msg.toString() : "null");
    }

    public void fatal(Object msg, Throwable t) {
        this.loggerDelegate.log(Level.SEVERE, msg != null ? msg.toString() : "null", t);
    }

    public void setLevelFatal() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelError() {
        this.setLevel(Level.SEVERE);
    }

    public void setLevelWarn() {
        this.setLevel(Level.WARNING);
    }

    public void setLevelInfo() {
        this.setLevel(Level.INFO);
    }

    public void setLevelDebug() {
        this.setLevel(Level.FINE);
    }

    public void setLevelTrace() {
        this.setLevel(Level.FINER);
    }

    public void setLevelAll() {
        this.setLevel(Level.ALL);
    }

    public void setLevelOff() {
        this.setLevel(Level.OFF);
    }

    private void setLevel(Level level) {
        Handler[] handlers;
        Handler[] handlerArray = handlers = this.loggerDelegate.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            handler.setLevel(level);
            ++n2;
        }
        this.loggerDelegate.setLevel(level);
    }

    public void reset() {
        try {
            FileHandler.pattern = null;
            LogManager.getLogManager().reset();
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception e) {
            this.loggerDelegate.log(Level.INFO, "Failed to reinit logger.", e);
        }
    }
}

