/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.TlvTools;

public class RvResponse
extends IcbmCommand {
    public static final int CODE_NOT_SUPPORTED = 0;
    public static final int CODE_DECLINED = 1;
    public static final int CODE_NOT_ACCEPTING = 2;
    private static final int TYPE_RESULT_CODE = 3;
    private final long rvSessionId;
    private final int channel;
    private final String sn;
    private final int code;

    protected RvResponse(SnacPacket snacPacket) {
        super(11);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.rvSessionId = BinaryTools.getLong(byteBlock, 0);
        this.channel = BinaryTools.getUShort(byteBlock, 8);
        ByteBlock byteBlock2 = byteBlock.subBlock(10);
        StringBlock stringBlock = OscarTools.readScreenname(byteBlock2);
        this.sn = stringBlock.getString();
        ByteBlock byteBlock3 = byteBlock2.subBlock(stringBlock.getTotalSize());
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock3);
        this.code = immutableTlvChain.getUShort(3);
    }

    public RvResponse(long l, int n, String string, int n2) {
        super(11);
        DefensiveTools.checkRange(n, "icbmChannel", 0);
        DefensiveTools.checkNull(string, "sn");
        DefensiveTools.checkRange(n2, "resultCode", -1);
        this.rvSessionId = l;
        this.channel = n;
        this.sn = string;
        this.code = n2;
    }

    public final long getRvSessionId() {
        return this.rvSessionId;
    }

    public final int getChannel() {
        return this.channel;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final int getResultCode() {
        return this.code;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeLong(outputStream, this.rvSessionId);
        BinaryTools.writeUShort(outputStream, this.channel);
        OscarTools.writeScreenname(outputStream, this.sn);
        BinaryTools.writeUShort(outputStream, this.code);
    }

    public String toString() {
        return "RvResponse: sn=" + this.sn + ": icbmChannel=" + this.channel + ", code=0x" + Integer.toHexString(this.code);
    }
}

