/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;
import net.kano.joscar.snaccmd.icbm.MissedMsgInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissedMessagesCmd
extends IcbmCommand {
    private final List<MissedMsgInfo> missedMsgInfos;

    protected MissedMessagesCmd(SnacPacket snacPacket) {
        super(10);
        MissedMsgInfo missedMsgInfo;
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ArrayList<MissedMsgInfo> arrayList = new ArrayList<MissedMsgInfo>();
        while ((missedMsgInfo = MissedMsgInfo.readMissedMsgInfo(byteBlock)) != null) {
            arrayList.add(missedMsgInfo);
            byteBlock = byteBlock.subBlock(missedMsgInfo.getTotalSize());
        }
        this.missedMsgInfos = DefensiveTools.getUnmodifiable(arrayList);
    }

    public MissedMessagesCmd(Collection<MissedMsgInfo> collection) {
        super(10);
        this.missedMsgInfos = DefensiveTools.getSafeNonnullListCopy(collection, "missedMsgInfos");
    }

    public final List<MissedMsgInfo> getMissedMsgInfos() {
        return this.missedMsgInfos;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.missedMsgInfos != null) {
            for (MissedMsgInfo missedMsgInfo : this.missedMsgInfos) {
                missedMsgInfo.write(outputStream);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MissedMessagesCmd: ");
        if (this.missedMsgInfos != null) {
            stringBuffer.append(this.missedMsgInfos.size());
            stringBuffer.append(" missed: ");
            boolean bl = true;
            for (MissedMsgInfo missedMsgInfo : this.missedMsgInfos) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(missedMsgInfo);
            }
        }
        return stringBuffer.toString();
    }
}

