/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.conn.ConnCommand;

public class SetIdleCmd
extends ConnCommand {
    public static final long IDLETIME_NOT_IDLE = 0L;
    private final long seconds;

    protected SetIdleCmd(SnacPacket snacPacket) {
        super(17);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        this.seconds = BinaryTools.getUInt(byteBlock, 0);
    }

    public SetIdleCmd(long l) {
        super(17);
        DefensiveTools.checkRange(l, "seconds", 0L);
        this.seconds = l;
    }

    public final long getSecondsIdle() {
        return this.seconds;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        BinaryTools.writeUInt(outputStream, this.seconds);
    }

    public String toString() {
        return "SetIdleCmd: seconds=" + this.seconds;
    }
}

