/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.rv.RvCommandFactory;
import net.kano.joscar.rvcmd.addins.AddinsAcceptRvCmd;
import net.kano.joscar.rvcmd.addins.AddinsRejectRvCmd;
import net.kano.joscar.rvcmd.addins.AddinsReqRvCmd;
import net.kano.joscar.rvcmd.chatinvite.ChatInvitationRvCmd;
import net.kano.joscar.rvcmd.chatinvite.ChatInviteRejectRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMAcceptRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMRejectRvCmd;
import net.kano.joscar.rvcmd.directim.DirectIMReqRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileAcceptRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileRejectRvCmd;
import net.kano.joscar.rvcmd.getfile.GetFileReqRvCmd;
import net.kano.joscar.rvcmd.icon.SendBuddyIconRvCmd;
import net.kano.joscar.rvcmd.sendbl.SendBuddyListRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendAcceptRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendRejectRvCmd;
import net.kano.joscar.rvcmd.sendfile.FileSendReqRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.AbstractTrillianCryptRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptAcceptRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptBeginRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptCloseRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptMsgRvCmd;
import net.kano.joscar.rvcmd.trillcrypt.TrillianCryptReqRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceAcceptRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceRejectRvCmd;
import net.kano.joscar.rvcmd.voice.VoiceReqRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRvCommandFactory
implements RvCommandFactory {
    private static final List<CapabilityBlock> SUPPORTED_CAPS = DefensiveTools.asUnmodifiableList(CapabilityBlock.BLOCK_FILE_SEND, CapabilityBlock.BLOCK_TRILLIANCRYPT, CapabilityBlock.BLOCK_SENDBUDDYLIST, CapabilityBlock.BLOCK_CHAT, CapabilityBlock.BLOCK_DIRECTIM, CapabilityBlock.BLOCK_FILE_GET, CapabilityBlock.BLOCK_ICON, CapabilityBlock.BLOCK_ADDINS, CapabilityBlock.BLOCK_VOICE);

    @Override
    public List<CapabilityBlock> getSupportedCapabilities() {
        return SUPPORTED_CAPS;
    }

    @Override
    public RvCommand genRvCommand(RecvRvIcbm recvRvIcbm) {
        DefensiveTools.checkNull(recvRvIcbm, "rvIcbm");
        CapabilityBlock capabilityBlock = recvRvIcbm.getCapability();
        int n = recvRvIcbm.getRvStatus();
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_FILE_SEND)) {
            if (n == 0) {
                return new FileSendReqRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new FileSendRejectRvCmd(recvRvIcbm);
            }
            if (n == 2) {
                return new FileSendAcceptRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_TRILLIANCRYPT)) {
            int n2 = AbstractTrillianCryptRvCmd.getTrillianCmdType(recvRvIcbm);
            if (n2 == 0) {
                return new TrillianCryptReqRvCmd(recvRvIcbm);
            }
            if (n2 == 1) {
                return new TrillianCryptAcceptRvCmd(recvRvIcbm);
            }
            if (n2 == 2) {
                return new TrillianCryptBeginRvCmd(recvRvIcbm);
            }
            if (n2 == 3) {
                return new TrillianCryptMsgRvCmd(recvRvIcbm);
            }
            if (n2 == 4) {
                return new TrillianCryptCloseRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_SENDBUDDYLIST)) {
            if (n == 0) {
                return new SendBuddyListRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_CHAT)) {
            if (n == 0) {
                return new ChatInvitationRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new ChatInviteRejectRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_DIRECTIM)) {
            if (n == 0) {
                return new DirectIMReqRvCmd(recvRvIcbm);
            }
            if (n == 2) {
                return new DirectIMAcceptRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new DirectIMRejectRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_FILE_GET)) {
            if (n == 0) {
                return new GetFileReqRvCmd(recvRvIcbm);
            }
            if (n == 2) {
                return new GetFileAcceptRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new GetFileRejectRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_ICON)) {
            if (n == 0) {
                return new SendBuddyIconRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_ADDINS)) {
            if (n == 0) {
                return new AddinsReqRvCmd(recvRvIcbm);
            }
            if (n == 2) {
                return new AddinsAcceptRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new AddinsRejectRvCmd(recvRvIcbm);
            }
            return null;
        }
        if (capabilityBlock.equals(CapabilityBlock.BLOCK_VOICE)) {
            if (n == 0) {
                return new VoiceReqRvCmd(recvRvIcbm);
            }
            if (n == 2) {
                return new VoiceAcceptRvCmd(recvRvIcbm);
            }
            if (n == 1) {
                return new VoiceRejectRvCmd(recvRvIcbm);
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return "DefaultRvCommandFactory";
    }
}

