/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.DefaultSsiItemObjFactory;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joscar.ssiitem.RootItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectFactory;
import net.kano.joustsim.oscar.oscar.service.ssi.AbstractGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.Buddy;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyListLayoutListener;
import net.kano.joustsim.oscar.oscar.service.ssi.ChangeTools;
import net.kano.joustsim.oscar.oscar.service.ssi.DetectedChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.Group;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddy;
import net.kano.joustsim.oscar.oscar.service.ssi.SimpleBuddyGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiSyntheticGroup;
import net.kano.joustsim.oscar.oscar.service.ssi.SyntheticGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleBuddyList
implements BuddyList,
SsiItemChangeListener {
    public static final Comparator<SimpleBuddy> COMPARATOR_SN = new Comparator<SimpleBuddy>(){

        @Override
        public int compare(SimpleBuddy o1, SimpleBuddy o2) {
            String sn1 = o1.getItem().getScreenname();
            String sn2 = o2.getItem().getScreenname();
            return sn1.compareToIgnoreCase(sn2);
        }
    };
    private static final Comparator<Group> COMPARATOR_GROUPNAME = new Comparator<Group>(){

        @Override
        public int compare(Group o1, Group o2) {
            if (o1 instanceof SsiSyntheticGroup) {
                return 1;
            }
            if (o2 instanceof SsiSyntheticGroup) {
                return -1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };
    private List<AbstractGroup> groups = new ArrayList<AbstractGroup>();
    private final SyntheticGroup syntheticGroup = new SyntheticGroup(this);
    private final SsiItemObjectFactory factory = new DefaultSsiItemObjFactory();
    private RootItem rootItem = null;
    private CopyOnWriteArrayList<BuddyListLayoutListener> listeners = new CopyOnWriteArrayList();

    SimpleBuddyList() {
    }

    protected SyntheticGroup getSyntheticGroup() {
        return this.syntheticGroup;
    }

    protected synchronized RootItem getRootItem() {
        return this.rootItem;
    }

    protected CopyOnWriteArrayList<BuddyListLayoutListener> getListeners() {
        return this.listeners;
    }

    @Override
    public void handleItemCreated(final SsiItem item) {
        this.runAndRecordChanges(new Runnable(){

            public void run() {
                SsiItemObj iobj = SimpleBuddyList.this.factory.getItemObj(item);
                SimpleBuddyList.this.handleItemCreated(iobj);
            }
        });
    }

    @Override
    public void handleItemModified(final SsiItem item) {
        this.runAndRecordChanges(new Runnable(){

            public void run() {
                SsiItemObj iobj = SimpleBuddyList.this.factory.getItemObj(item);
                SimpleBuddyList.this.handleItemModified(iobj);
            }
        });
    }

    @Override
    public void handleItemDeleted(final SsiItem item) {
        this.runAndRecordChanges(new Runnable(){

            public void run() {
                SimpleBuddyList.this.handleItemActuallyDeleted(item);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndRecordChanges(Runnable runnable) {
        ListState newShot;
        ListState saved;
        SimpleBuddyList simpleBuddyList = this;
        synchronized (simpleBuddyList) {
            saved = this.takeSnapshot();
            runnable.run();
            newShot = this.takeSnapshot();
        }
        this.detectChanges(saved, newShot);
    }

    private synchronized ListState takeSnapshot() {
        return new ListState(false);
    }

    private void detectChanges(ListState oldState, ListState newState) {
        ArrayList oldGroups = new ArrayList(oldState.getBuddies().keySet());
        ArrayList newGroups = new ArrayList(newState.getBuddies().keySet());
        ChangeTools.detectChanges(oldGroups, newGroups, new GroupChangeListener(oldState, newState));
        for (AbstractGroup group : newGroups) {
            this.detectChangesInGroup(oldState, newState, group);
        }
    }

    private void detectChangesInGroup(ListState oldState, ListState newState, AbstractGroup group) {
        List<SimpleBuddy> oldBuddies = oldState.getBuddies(group);
        if (oldBuddies == null) {
            return;
        }
        List<SimpleBuddy> newBuddies = newState.getBuddies(group);
        if (newBuddies == null) {
            return;
        }
        ChangeTools.detectChanges(oldBuddies, newBuddies, new BuddyChangeListener(group));
        group.detectChanges(oldState.getGroupState(group), newState.getGroupState(group));
        for (SimpleBuddy buddy : newBuddies) {
            SimpleBuddy.BuddyState oldBuddyState = oldState.getBuddyState(buddy);
            SimpleBuddy.BuddyState newBuddyState = newState.getBuddyState(buddy);
            if (oldBuddyState == null || newBuddyState == null) continue;
            buddy.detectChanges(oldBuddyState, newBuddyState);
        }
    }

    private synchronized void handleItemCreated(SsiItemObj item) {
        if (item instanceof RootItem) {
            RootItem rootItem;
            this.rootItem = rootItem = (RootItem)item;
            this.sortGroups();
        } else if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            SimpleBuddyGroup newGroup = this.createBuddyGroup(groupItem);
            this.groups.add(newGroup);
            ArrayList<SimpleBuddy> moveBuddies = new ArrayList<SimpleBuddy>();
            for (SimpleBuddy buddy : this.syntheticGroup.getBuddiesCopy()) {
                if (buddy.getItem().getGroupId() != groupItem.getId()) continue;
                moveBuddies.add(buddy);
            }
            this.syntheticGroup.removeBuddies(moveBuddies);
            this.syntheticGroup.sortBuddies();
            newGroup.addBuddies(moveBuddies);
            newGroup.sortBuddies();
            if (this.syntheticGroup.getBuddiesCopy().isEmpty()) {
                this.groups.remove(this.syntheticGroup);
            }
            this.sortGroups();
        } else if (item instanceof BuddyItem) {
            BuddyItem buddyItem = (BuddyItem)item;
            SimpleBuddy buddy = this.createBuddy(buddyItem);
            AbstractGroup group = this.getGroup(buddyItem.getGroupId());
            if (group == null && !this.groups.contains(group = this.syntheticGroup)) {
                this.groups.add(group);
                this.sortGroups();
            }
            group.addBuddy(buddy);
            group.sortBuddies();
        }
    }

    protected SimpleBuddy createBuddy(BuddyItem buddyItem) {
        return new SimpleBuddy(this, buddyItem);
    }

    protected SimpleBuddyGroup createBuddyGroup(GroupItem groupItem) {
        return new SimpleBuddyGroup(this, groupItem);
    }

    private synchronized Runnable handleItemModified(SsiItemObj newItem) {
        if (newItem instanceof RootItem) {
            RootItem rootItem;
            this.rootItem = rootItem = (RootItem)newItem;
            this.sortGroups();
        } else {
            if (newItem instanceof GroupItem) {
                GroupItem groupItem = (GroupItem)newItem;
                final SimpleBuddyGroup group = this.getGroup(groupItem.getId());
                if (group == null) {
                    throw new IllegalStateException("group " + groupItem + " was modified but it's not present in group list");
                }
                final AbstractGroup.GroupState state = group.saveState();
                group.setItem(groupItem);
                final AbstractGroup.GroupState newState = group.saveState();
                group.sortBuddies();
                return new Runnable(){

                    public void run() {
                        group.detectChanges(state, newState);
                    }
                };
            }
            if (newItem instanceof BuddyItem) {
                BuddyItem buddyItem = (BuddyItem)newItem;
                AbstractGroup group = this.getActualGroup(buddyItem.getGroupId());
                SimpleBuddy buddy = group.getBuddy(buddyItem.getId());
                buddy.setItem(buddyItem);
            }
        }
        return null;
    }

    private synchronized void handleItemActuallyDeleted(SsiItem item) {
        int type = item.getItemType();
        if (type == 1) {
            if (DefaultSsiItemObjFactory.isRootItem((SsiItem)item)) {
                this.rootItem = null;
                this.sortGroups();
            } else {
                SimpleBuddyGroup group = this.getGroup(item.getParentId());
                if (group == null) {
                    throw new IllegalStateException("group " + item + " was " + "supposedly deleted but we have no record of it");
                }
                List<SimpleBuddy> buddies = group.getBuddiesCopy();
                if (!buddies.isEmpty()) {
                    if (!this.groups.contains(this.syntheticGroup)) {
                        this.groups.add(this.syntheticGroup);
                    }
                    this.syntheticGroup.addBuddies(buddies);
                    this.syntheticGroup.sortBuddies();
                }
                this.groups.remove(group);
                this.sortGroups();
                group.setActive(false);
            }
        } else if (type == 0) {
            AbstractGroup group = this.getActualGroup(item.getParentId());
            SimpleBuddy buddy = group.getBuddy(item.getId());
            group.removeBuddy(buddy);
            group.sortBuddies();
            if (group == this.syntheticGroup && group.getBuddiesCopy().isEmpty()) {
                this.groups.remove(group);
                this.sortGroups();
            }
            buddy.setActive(false);
        }
    }

    private synchronized void sortGroups() {
        ArrayList<AbstractGroup> leftover;
        List<AbstractGroup> oldGroups = this.groups;
        ArrayList<AbstractGroup> newGroups = new ArrayList<AbstractGroup>();
        RootItem rootItem = this.rootItem;
        if (rootItem != null) {
            HashMap<Integer, SimpleBuddyGroup> id2group = new HashMap<Integer, SimpleBuddyGroup>();
            for (AbstractGroup group : oldGroups) {
                if (!(group instanceof SimpleBuddyGroup)) continue;
                SimpleBuddyGroup buddyGroup = (SimpleBuddyGroup)group;
                id2group.put(buddyGroup.getItem().getId(), buddyGroup);
            }
            int[] groupids = rootItem.getGroupids();
            if (groupids != null) {
                for (int groupId : groupids) {
                    AbstractGroup group = (AbstractGroup)id2group.remove(groupId);
                    if (group == null) continue;
                    newGroups.add(group);
                }
            }
            leftover = new ArrayList(id2group.values());
        } else {
            leftover = new ArrayList<AbstractGroup>(oldGroups);
        }
        Collections.sort(leftover, COMPARATOR_GROUPNAME);
        newGroups.addAll(leftover);
        assert (!newGroups.contains(this.syntheticGroup) || newGroups.indexOf(this.syntheticGroup) == newGroups.size() - 1);
        this.groups = newGroups;
    }

    private synchronized SimpleBuddyGroup getGroup(int groupId) {
        for (AbstractGroup group : this.groups) {
            SimpleBuddyGroup buddyGroup;
            if (!(group instanceof SimpleBuddyGroup) || (buddyGroup = (SimpleBuddyGroup)group).getItem().getId() != groupId) continue;
            return buddyGroup;
        }
        return null;
    }

    private AbstractGroup getActualGroup(int groupId) {
        AbstractGroup group = this.getGroup(groupId);
        if (group == null) {
            group = this.syntheticGroup;
        }
        return group;
    }

    Object getLock() {
        return this;
    }

    @Override
    public void addLayoutListener(BuddyListLayoutListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeLayoutListener(BuddyListLayoutListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public synchronized List<? extends Group> getGroups() {
        return DefensiveTools.getUnmodifiableCopy(this.groups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRetroactiveLayoutListener(BuddyListLayoutListener listener) {
        ListState state;
        ListState empty = new ListState(true);
        SimpleBuddyList simpleBuddyList = this;
        synchronized (simpleBuddyList) {
            this.addLayoutListener(listener);
            state = this.takeSnapshot();
        }
        this.detectChanges(empty, state);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuddyChangeListener
    implements DetectedChangeListener<SimpleBuddy> {
        private final Group group;

        public BuddyChangeListener(Group group) {
            this.group = group;
        }

        @Override
        public void itemAdded(Collection<? extends SimpleBuddy> oldItems, Collection<? extends SimpleBuddy> newItems, SimpleBuddy item) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.buddyAdded(SimpleBuddyList.this, this.group, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemRemoved(Collection<? extends SimpleBuddy> oldItems, Collection<? extends SimpleBuddy> newItems, SimpleBuddy item) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.buddyRemoved(SimpleBuddyList.this, this.group, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemsReordered(Collection<? extends SimpleBuddy> oldItems, Collection<? extends SimpleBuddy> newItems) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.buddiesReordered(SimpleBuddyList.this, this.group, oldItemsCopy, newItemsCopy);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupChangeListener
    implements DetectedChangeListener<Group> {
        private ListState oldState;
        private ListState newState;

        public GroupChangeListener(ListState oldState, ListState newState) {
            this.oldState = oldState;
            this.newState = newState;
        }

        @Override
        public void itemAdded(Collection<? extends Group> oldItems, Collection<? extends Group> newItems, Group item) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.groupAdded(SimpleBuddyList.this, oldItemsCopy, newItemsCopy, item, this.newState.getBuddies(item));
            }
        }

        @Override
        public void itemRemoved(Collection<? extends Group> oldItems, Collection<? extends Group> newItems, Group item) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.groupRemoved(SimpleBuddyList.this, oldItemsCopy, newItemsCopy, item);
            }
        }

        @Override
        public void itemsReordered(Collection<? extends Group> oldItems, Collection<? extends Group> newItems) {
            assert (!Thread.holdsLock(SimpleBuddyList.this));
            List oldItemsCopy = DefensiveTools.getUnmodifiableCopy(oldItems);
            List newItemsCopy = DefensiveTools.getUnmodifiableCopy(newItems);
            for (BuddyListLayoutListener listener : SimpleBuddyList.this.listeners) {
                listener.groupsReordered(SimpleBuddyList.this, oldItemsCopy, newItemsCopy);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListState {
        private final Map<AbstractGroup, List<SimpleBuddy>> buddies;
        private final Map<AbstractGroup, AbstractGroup.GroupState> groupStates;
        private final Map<SimpleBuddy, SimpleBuddy.BuddyState> buddyStates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListState(boolean empty) {
            if (empty) {
                this.buddies = Collections.EMPTY_MAP;
                this.groupStates = Collections.EMPTY_MAP;
                this.buddyStates = Collections.EMPTY_MAP;
            } else {
                SimpleBuddyList simpleBuddyList2 = SimpleBuddyList.this;
                synchronized (simpleBuddyList2) {
                    LinkedHashMap<AbstractGroup, List<SimpleBuddy>> buddies = new LinkedHashMap<AbstractGroup, List<SimpleBuddy>>();
                    HashMap<AbstractGroup, AbstractGroup.GroupState> groupStates = new HashMap<AbstractGroup, AbstractGroup.GroupState>();
                    HashMap<SimpleBuddy, SimpleBuddy.BuddyState> buddyStates = new HashMap<SimpleBuddy, SimpleBuddy.BuddyState>();
                    for (AbstractGroup group : SimpleBuddyList.this.groups) {
                        buddies.put(group, group.getBuddiesCopy());
                        groupStates.put(group, group.saveState());
                        for (SimpleBuddy buddy : group.getBuddies()) {
                            buddyStates.put(buddy, buddy.saveState());
                        }
                    }
                    this.buddies = Collections.unmodifiableMap(buddies);
                    this.groupStates = Collections.unmodifiableMap(groupStates);
                    this.buddyStates = Collections.unmodifiableMap(buddyStates);
                }
            }
        }

        private Map<AbstractGroup, List<SimpleBuddy>> getBuddies() {
            return this.buddies;
        }

        public Map<AbstractGroup, AbstractGroup.GroupState> getGroupStates() {
            return this.groupStates;
        }

        public List<SimpleBuddy> getBuddies(Group group) {
            return this.buddies.get(group);
        }

        public AbstractGroup.GroupState getGroupState(Group group) {
            return this.groupStates.get(group);
        }

        public Map<SimpleBuddy, SimpleBuddy.BuddyState> getBuddyStates() {
            return this.buddyStates;
        }

        public SimpleBuddy.BuddyState getBuddyState(Buddy buddy) {
            return this.buddyStates.get(buddy);
        }
    }
}

