/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.chatrooms;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.OscarTools;
import net.kano.joscar.rv.RecvRvEvent;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rv.RvSnacResponseEvent;
import net.kano.joscar.rvcmd.chatinvite.ChatInvitationRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.MiniRoomInfo;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AbstractCapabilityHandler;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.CapabilityManager;
import net.kano.joustsim.oscar.oscar.BasicConnection;
import net.kano.joustsim.oscar.oscar.NoBuddyKeysException;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.ServiceListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.BadKeyException;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitation;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatInvitationImpl;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomManagerListener;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatRoomSession;
import net.kano.joustsim.oscar.oscar.service.chatrooms.ChatSessionState;
import net.kano.joustsim.oscar.oscar.service.chatrooms.EncryptedChatRoomMessageFactory;
import net.kano.joustsim.oscar.oscar.service.chatrooms.IncompleteInvitationInfo;
import net.kano.joustsim.oscar.oscar.service.chatrooms.InvalidInvitationReason;
import net.kano.joustsim.oscar.oscar.service.chatrooms.KeyExtractionTools;
import net.kano.joustsim.oscar.oscar.service.chatrooms.NoPrivateKeyException;
import net.kano.joustsim.oscar.oscar.service.chatrooms.PlainChatRoomMessageFactory;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderService;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceArbiter;
import net.kano.joustsim.oscar.oscar.service.chatrooms.RoomFinderServiceListener;
import net.kano.joustsim.oscar.oscar.service.icbm.IcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousCapabilityHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import org.jetbrains.annotations.NotNull;

public class ChatRoomManager {
    private static final Logger LOGGER = Logger.getLogger(ChatRoomManager.class.getName());
    private final AimConnection aimConnection;
    private CopyOnWriteArrayList<ChatRoomManagerListener> listeners = new CopyOnWriteArrayList();
    private Map<RoomDescriptor, ChatRoomSession> sessions = new HashMap<RoomDescriptor, ChatRoomSession>();
    private static final int DEFAULT_EXCHANGE = 4;
    private Map<InvitationRecord, IncompleteInvitationInfo> pendingInvitations = new LinkedHashMap<InvitationRecord, IncompleteInvitationInfo>();
    private final Object pendingInvitationsLock = new Object();

    public ChatRoomManager(AimConnection conn) {
        this.aimConnection = conn;
        conn.getCapabilityManager().setCapabilityHandler(CapabilityBlock.BLOCK_CHAT, new ChatInvitationCapabilityHandler());
        RoomFinderServiceArbiter arbiter = conn.getExternalServiceManager().getChatRoomFinderServiceArbiter();
        arbiter.addRoomManagerServiceListener(new MyRoomFinderServiceListener());
    }

    public AimConnection getAimConnection() {
        return this.aimConnection;
    }

    public void addListener(ChatRoomManagerListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    public void removeListener(ChatRoomManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    void rejectInvitation(ChatInvitationImpl inv) {
        boolean wasRejected;
        ChatInvitationImpl invitation = this.ensureGoodInvitation(inv);
        boolean bl = wasRejected = !invitation.setRejected();
        if (wasRejected) {
            return;
        }
        invitation.getSession().sendResponse(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChatRoomSession acceptInvitation(ChatInvitationImpl inv) throws IllegalArgumentException {
        ChatRoomSession session;
        ChatInvitationImpl chatInvitation = this.ensureGoodInvitation(inv);
        if (!chatInvitation.isAcceptable()) {
            throw new IllegalArgumentException("Chat invitation is not valid: " + inv);
        }
        FullRoomInfo info = chatInvitation.getRoomInfo();
        ChatRoomManager chatRoomManager = this;
        synchronized (chatRoomManager) {
            RoomDescriptor descriptor = new RoomDescriptor(chatInvitation.getRoomInfo());
            session = this.sessions.get(descriptor);
            if (session != null) {
                return session;
            }
            session = new ChatRoomSession(this.aimConnection);
            session.setRoomInfo(info);
            session.setInvitation(chatInvitation);
            this.sessions.put(descriptor, session);
        }
        LOGGER.fine("Attempting to accept invitation to join " + info);
        this.getChatArbiter().joinChatRoom(info);
        return session;
    }

    private ChatInvitationImpl ensureGoodInvitation(ChatInvitation inv) {
        if (!(inv instanceof ChatInvitationImpl)) {
            throw new IllegalArgumentException("Invitation was not received by this chat manager: " + inv);
        }
        ChatInvitationImpl chatInvitation = (ChatInvitationImpl)inv;
        if (chatInvitation.getChatRoomManager() != this) {
            throw new IllegalArgumentException("Invitation was not received by this chat manager: " + inv);
        }
        return chatInvitation;
    }

    public ChatRoomSession joinRoom(String name) {
        return this.joinRoom(4, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomSession joinRoom(int exchange, String name) {
        ChatRoomSession session;
        ChatRoomManager chatRoomManager = this;
        synchronized (chatRoomManager) {
            RoomDescriptor descriptor = new RoomDescriptor(exchange, 65535, name);
            session = this.sessions.get(descriptor);
            if (session != null) {
                return session;
            }
            session = new ChatRoomSession(this.aimConnection);
            this.sessions.put(descriptor, session);
        }
        RoomFinderServiceArbiter arbiter = this.getChatArbiter();
        arbiter.joinChatRoom(exchange, name);
        return session;
    }

    private RoomFinderServiceArbiter getChatArbiter() {
        return this.aimConnection.getExternalServiceManager().getChatRoomFinderServiceArbiter();
    }

    private InvitationRecord makeInvitationRecord(Screenname sn, MiniRoomInfo roomInfo) {
        return new InvitationRecord(sn, roomInfo.getExchange(), OscarTools.getRoomNameFromCookie((String)roomInfo.getCookie()), roomInfo.getInstance());
    }

    private void registerInvitation(IncompleteInvitationInfo invitation, FullRoomInfo roomInfo) {
        ChatInvitationImpl ourInvitation;
        if (invitation.getSecurityInfo() == null) {
            ourInvitation = new ChatInvitationImpl(this, invitation.getSession(), invitation.getSn(), roomInfo, invitation.getMsgString());
        } else if (invitation.getRoomKey() == null) {
            ourInvitation = new ChatInvitationImpl(this, invitation.getSession(), invitation.getSn(), roomInfo, invitation.getReason(), invitation.getMsgString());
        } else {
            assert (invitation.getBuddyCert() != null);
            ourInvitation = new ChatInvitationImpl(this, invitation.getSession(), invitation.getSn(), roomInfo, invitation.getBuddyCert(), invitation.getRoomKey(), invitation.getMsgString());
        }
        LOGGER.fine("Firing invitation: " + ourInvitation);
        for (ChatRoomManagerListener listener : this.listeners) {
            listener.handleInvitation(this, ourInvitation);
        }
    }

    private synchronized ChatRoomSession getSession(FullRoomInfo roomInfo) {
        ChatRoomSession session = this.sessions.get(new RoomDescriptor(roomInfo));
        if (session == null) {
            session = this.sessions.get(new RoomDescriptor(roomInfo.getExchange(), 65535, roomInfo.getName()));
        }
        return session;
    }

    private static class RoomDescriptor {
        private int exchange;
        private int instance;
        @NotNull
        private String name;

        public RoomDescriptor(int exchange, int instance, @NotNull String name) {
            this.exchange = exchange;
            this.instance = instance;
            this.name = name;
        }

        public RoomDescriptor(FullRoomInfo roomInfo) {
            this(roomInfo.getExchange(), roomInfo.getInstance(), roomInfo.getName());
        }

        public int getExchange() {
            return this.exchange;
        }

        public int getInstance() {
            return this.instance;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoomDescriptor that = (RoomDescriptor)o;
            if (this.exchange != that.exchange) {
                return false;
            }
            if (this.instance != that.instance) {
                return false;
            }
            return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
        }

        public int hashCode() {
            int result = this.exchange;
            result = 29 * result + this.instance;
            result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }
    }

    private class MyServiceListener
    implements ServiceListener {
        private ChatRoomSession session;

        public MyServiceListener(ChatRoomSession session) {
            this.session = session;
        }

        public void handleServiceReady(Service service) {
            if (!(service instanceof ChatRoomService)) {
                return;
            }
            ChatRoomService roomService = (ChatRoomService)service;
            LOGGER.fine("Service for " + roomService.getRoomName() + " is ready");
            String contentType = roomService.getRoomInfo().getContentType();
            if (contentType.equals("application/pkcs7-mime")) {
                roomService.setMessageFactory(new EncryptedChatRoomMessageFactory(ChatRoomManager.this.aimConnection, roomService, this.session.getInvitationImpl().getRoomKey()));
            } else {
                if (!contentType.equals("text/x-aolrtf")) {
                    LOGGER.warning("Chat room " + this.session.getRoomInfo().getName() + " has unknown content type: " + contentType);
                }
                roomService.setMessageFactory(new PlainChatRoomMessageFactory());
            }
            this.session.setService(roomService);
        }

        public void handleServiceFinished(Service service) {
        }
    }

    private class MyRoomFinderServiceListener
    implements RoomFinderServiceListener {
        private MyRoomFinderServiceListener() {
        }

        public void handleNewChatRoom(RoomFinderService service, FullRoomInfo roomInfo, BasicConnection connection) {
            ChatRoomSession session = ChatRoomManager.this.getSession(roomInfo);
            assert (session != null) : "No session for " + roomInfo;
            session.setRoomInfo(roomInfo);
            session.setConnection(connection);
            session.setState(ChatSessionState.CONNECTING);
            LOGGER.fine("Opened new chat room connection for " + roomInfo.getName());
            connection.addGlobalServiceListener(new MyServiceListener(session));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRoomInfo(RoomFinderService service, MiniRoomInfo mini, FullRoomInfo info) {
            LOGGER.fine("Got room info for pending invitation: " + info);
            ArrayList<IncompleteInvitationInfo> uses = new ArrayList<IncompleteInvitationInfo>();
            Object object = ChatRoomManager.this.pendingInvitationsLock;
            synchronized (object) {
                Iterator it = ChatRoomManager.this.pendingInvitations.values().iterator();
                while (it.hasNext()) {
                    IncompleteInvitationInfo invinfo = (IncompleteInvitationInfo)it.next();
                    if (!invinfo.getRoomInfo().isSameRoom(mini)) continue;
                    it.remove();
                    uses.add(invinfo);
                }
            }
            for (IncompleteInvitationInfo use : uses) {
                ChatRoomManager.this.registerInvitation(use, info);
            }
        }
    }

    private class MyRendezvousSessionHandler
    implements RendezvousSessionHandler {
        private RvSession session;

        public MyRendezvousSessionHandler(RvSession session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRv(RecvRvEvent event) {
            RvCommand cmd = event.getRvCommand();
            if (cmd instanceof ChatInvitationRvCmd) {
                ChatInvitationRvCmd invitation = (ChatInvitationRvCmd)cmd;
                Screenname sn = new Screenname(event.getRvSession().getScreenname());
                SecretKey roomKey = null;
                InvalidInvitationReason reason = null;
                X509Certificate buddyCert = null;
                ByteBlock securityInfo = invitation.getSecurityInfo();
                if (securityInfo != null) {
                    try {
                        buddyCert = KeyExtractionTools.getBuddySigningCert(sn, ChatRoomManager.this.aimConnection.getBuddyInfoManager());
                        assert (buddyCert != null);
                    }
                    catch (NoBuddyKeysException e) {
                        reason = InvalidInvitationReason.NO_BUDDY_KEYS;
                    }
                    try {
                        roomKey = KeyExtractionTools.extractChatKey(securityInfo, buddyCert, ChatRoomManager.this.aimConnection.getLocalPrefs());
                        assert (roomKey != null);
                    }
                    catch (NoPrivateKeyException e) {
                        reason = InvalidInvitationReason.NO_LOCAL_KEYS;
                    }
                    catch (CertificateNotYetValidException e) {
                        reason = InvalidInvitationReason.CERT_NOT_YET_VALID;
                    }
                    catch (CertificateExpiredException e) {
                        reason = InvalidInvitationReason.CERT_EXPIRED;
                    }
                    catch (BadKeyException e) {
                        reason = InvalidInvitationReason.INVALID_SIGNATURE;
                    }
                }
                MiniRoomInfo roomInfo = invitation.getRoomInfo();
                String msgString = invitation.getInvMessage().getMessage();
                Object object = ChatRoomManager.this.pendingInvitationsLock;
                synchronized (object) {
                    ChatRoomManager.this.pendingInvitations.put(ChatRoomManager.this.makeInvitationRecord(sn, roomInfo), new IncompleteInvitationInfo(this.session, sn, roomInfo, msgString, roomKey, securityInfo, reason, buddyCert));
                }
                LOGGER.info("Got invitation from " + sn + " to " + roomInfo + ": " + msgString + "; requesting more information");
                ChatRoomManager.this.aimConnection.getExternalServiceManager().getChatRoomFinderServiceArbiter().getRoomInfo(roomInfo);
            }
        }

        public void handleSnacResponse(RvSnacResponseEvent event) {
        }
    }

    private static class InvitationRecord {
        private Screenname inviter;
        private int exchange;
        private String roomName;
        private int instance;

        public InvitationRecord(Screenname screenname, int exchange, String roomName, int instance) {
            this.inviter = screenname;
            this.exchange = exchange;
            this.roomName = roomName;
            this.instance = instance;
        }

        public Screenname getInviter() {
            return this.inviter;
        }

        public int getExchange() {
            return this.exchange;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public int getInstance() {
            return this.instance;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvitationRecord that = (InvitationRecord)o;
            if (this.exchange != that.exchange) {
                return false;
            }
            if (this.instance != that.instance) {
                return false;
            }
            if (!this.roomName.equals(that.roomName)) {
                return false;
            }
            return this.inviter.equals(that.inviter);
        }

        public int hashCode() {
            int result = this.inviter.hashCode();
            result = 29 * result + this.exchange;
            result = 29 * result + this.roomName.hashCode();
            result = 29 * result + this.instance;
            return result;
        }
    }

    private class ChatInvitationCapabilityHandler
    extends AbstractCapabilityHandler
    implements RendezvousCapabilityHandler {
        private ChatInvitationCapabilityHandler() {
        }

        public RendezvousSessionHandler handleSession(IcbmService service, RvSession session) {
            return new MyRendezvousSessionHandler(session);
        }

        public void handleAdded(CapabilityManager manager) {
        }

        public void handleRemoved(CapabilityManager manager) {
        }
    }
}

