/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;

public abstract class RrdBackend {
    private String path;
    private static long count;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RrdBackend(String path) {
        this.path = path;
        ++count;
    }

    public String getPath() {
        return this.path;
    }

    protected abstract void write(long var1, byte[] var3) throws IOException;

    protected abstract void read(long var1, byte[] var3) throws IOException;

    public final byte[] readAll() throws IOException {
        byte[] b = new byte[(int)this.getLength()];
        this.read(0L, b);
        return b;
    }

    public abstract long getLength() throws IOException;

    protected abstract void setLength(long var1) throws IOException;

    public void close() throws IOException {
        this.sync();
    }

    protected void beforeUpdate() throws IOException {
    }

    protected void afterUpdate() throws IOException {
    }

    protected void beforeFetch() throws IOException {
    }

    protected void afterFetch() throws IOException {
    }

    protected void afterCreate() throws IOException {
    }

    public void sync() throws IOException {
    }

    final void writeInt(long offset, int value) throws IOException {
        this.write(offset, RrdBackend.getIntBytes(value));
    }

    final void writeLong(long offset, long value) throws IOException {
        this.write(offset, RrdBackend.getLongBytes(value));
    }

    final void writeDouble(long offset, double value) throws IOException {
        this.write(offset, RrdBackend.getDoubleBytes(value));
    }

    final void writeDouble(long offset, double value, int count) throws IOException {
        byte[] b = RrdBackend.getDoubleBytes(value);
        byte[] image = new byte[8 * count];
        int k = 0;
        for (int i = 0; i < count; ++i) {
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
        }
        this.write(offset, image);
        image = null;
    }

    final void writeDouble(long offset, double[] values) throws IOException {
        int count = values.length;
        byte[] image = new byte[8 * count];
        int k = 0;
        for (int i = 0; i < count; ++i) {
            byte[] b = RrdBackend.getDoubleBytes(values[i]);
            image[k++] = b[0];
            image[k++] = b[1];
            image[k++] = b[2];
            image[k++] = b[3];
            image[k++] = b[4];
            image[k++] = b[5];
            image[k++] = b[6];
            image[k++] = b[7];
        }
        this.write(offset, image);
        image = null;
    }

    final void writeString(long offset, String value) throws IOException {
        value = value.trim();
        byte[] b = new byte[40];
        int k = 0;
        for (int i = 0; i < 20; ++i) {
            char c = i < value.length() ? (char)value.charAt(i) : (char)' ';
            byte[] cb = RrdBackend.getCharBytes(c);
            b[k++] = cb[0];
            b[k++] = cb[1];
        }
        this.write(offset, b);
    }

    final int readInt(long offset) throws IOException {
        byte[] b = new byte[4];
        this.read(offset, b);
        return RrdBackend.getInt(b);
    }

    final long readLong(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getLong(b);
    }

    final double readDouble(long offset) throws IOException {
        byte[] b = new byte[8];
        this.read(offset, b);
        return RrdBackend.getDouble(b);
    }

    final double[] readDouble(long offset, int count) throws IOException {
        int byteCount = 8 * count;
        byte[] image = new byte[byteCount];
        this.read(offset, image);
        double[] values = new double[count];
        int k = -1;
        for (int i = 0; i < count; ++i) {
            byte[] b = new byte[]{image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k], image[++k]};
            values[i] = RrdBackend.getDouble(b);
        }
        image = null;
        return values;
    }

    final String readString(long offset) throws IOException {
        byte[] b = new byte[40];
        char[] c = new char[20];
        this.read(offset, b);
        int k = -1;
        for (int i = 0; i < 20; ++i) {
            byte[] cb = new byte[]{b[++k], b[++k]};
            c[i] = RrdBackend.getChar(cb);
        }
        return new String(c).trim();
    }

    private static final byte[] getIntBytes(int value) {
        byte[] b = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value >>> 0 & 0xFF)};
        return b;
    }

    private static final byte[] getLongBytes(long value) {
        byte[] b = new byte[]{(byte)((int)(value >>> 56) & 0xFF), (byte)((int)(value >>> 48) & 0xFF), (byte)((int)(value >>> 40) & 0xFF), (byte)((int)(value >>> 32) & 0xFF), (byte)((int)(value >>> 24) & 0xFF), (byte)((int)(value >>> 16) & 0xFF), (byte)((int)(value >>> 8) & 0xFF), (byte)((int)(value >>> 0) & 0xFF)};
        return b;
    }

    private static final byte[] getCharBytes(char value) {
        byte[] b = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value >>> 0 & 0xFF)};
        return b;
    }

    private static final byte[] getDoubleBytes(double value) {
        byte[] bytes = RrdBackend.getLongBytes(Double.doubleToLongBits(value));
        return bytes;
    }

    private static final int getInt(byte[] b) {
        if (!$assertionsDisabled && b.length != 4) {
            throw new AssertionError((Object)"Invalid number of bytes for integer conversion");
        }
        return (b[0] << 24 & 0xFF000000) + (b[1] << 16 & 0xFF0000) + (b[2] << 8 & 0xFF00) + (b[3] << 0 & 0xFF);
    }

    private static final long getLong(byte[] b) {
        if (!$assertionsDisabled && b.length != 8) {
            throw new AssertionError((Object)"Invalid number of bytes for long conversion");
        }
        int high = RrdBackend.getInt(new byte[]{b[0], b[1], b[2], b[3]});
        int low = RrdBackend.getInt(new byte[]{b[4], b[5], b[6], b[7]});
        long value = ((long)high << 32) + ((long)low & 0xFFFFFFFFL);
        return value;
    }

    private static final char getChar(byte[] b) {
        if (!$assertionsDisabled && b.length != 2) {
            throw new AssertionError((Object)"Invalid number of bytes for char conversion");
        }
        return (char)((b[0] << 8 & 0xFF00) + (b[1] << 0 & 0xFF));
    }

    private static final double getDouble(byte[] b) {
        if (!$assertionsDisabled && b.length != 8) {
            throw new AssertionError((Object)"Invalid number of bytes for double conversion");
        }
        return Double.longBitsToDouble(RrdBackend.getLong(b));
    }

    static long getCount() {
        return count;
    }

    static {
        $assertionsDisabled = !RrdBackend.class.desiredAssertionStatus();
        count = 0L;
    }
}

