/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.beans;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.LangAttributePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyIterator;
import org.apache.commons.jxpath.ri.model.beans.PropertyOwnerPointer;

public class BeanAttributeIterator
extends PropertyIterator {
    private NodePointer parent;
    private int position = 0;
    private boolean includeXmlLang;

    public BeanAttributeIterator(PropertyOwnerPointer parent, QName name) {
        super(parent, (String)(name.getPrefix() == null && (name.getName() == null || name.getName().equals("*")) ? null : name.toString()), false, null);
        this.parent = parent;
        this.includeXmlLang = name.getPrefix() != null && name.getPrefix().equals("xml") && (name.getName().equals("lang") || name.getName().equals("*"));
    }

    public NodePointer getNodePointer() {
        if (this.includeXmlLang && this.position == 1) {
            return new LangAttributePointer(this.parent);
        }
        return super.getNodePointer();
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        if (this.includeXmlLang) {
            if (position == 1) {
                return true;
            }
            return super.setPosition(position - 1);
        }
        this.position = position;
        return super.setPosition(position);
    }
}

