/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Area;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Line;
import org.jrobin.graph.PlotDef;

class Stack
extends PlotDef {
    Stack(String sourceName, Color color) {
        super(sourceName, color);
        this.plotType = 2;
    }

    void draw(ChartGraphics g, int[] xValues, double[] stackValues, int lastPlotType) throws RrdException {
        PlotDef stack = null;
        try {
            if (lastPlotType == 0) {
                stack = new Line(this.source, this.values, this.color, true, this.visible);
            } else if (lastPlotType == 1) {
                stack = new Area(this.source, this.values, this.color, true, this.visible);
            }
            stack.draw(g, xValues, stackValues, lastPlotType);
        }
        catch (Exception e) {
            throw new RrdException("Could not stack source: " + this.sourceName);
        }
    }

    void exportXmlTemplate(XmlWriter xml, String legend) {
        xml.startTag("stack");
        xml.writeTag("datasource", this.sourceName);
        xml.writeTag("color", this.color);
        xml.writeTag("legend", legend);
        xml.closeTag();
    }
}

