/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.util.HashMap;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdFileBackendFactory;
import org.jrobin.core.RrdMemoryBackendFactory;
import org.jrobin.core.RrdNioBackendFactory;

public abstract class RrdBackendFactory {
    private static final HashMap factories = new HashMap();
    private static RrdBackendFactory defaultFactory;

    public static synchronized RrdBackendFactory getFactory(String name) throws RrdException {
        RrdBackendFactory factory = (RrdBackendFactory)factories.get(name);
        if (factory != null) {
            return factory;
        }
        throw new RrdException("No backend factory found with the name specified [" + name + "]");
    }

    public static synchronized void registerFactory(RrdBackendFactory factory) throws RrdException {
        String name = factory.getFactoryName();
        if (factories.containsKey(name)) {
            throw new RrdException("Backend factory of this name2 (" + name + ") already exists and cannot be registered");
        }
        factories.put(name, factory);
    }

    public static synchronized void registerAndSetAsDefaultFactory(RrdBackendFactory factory) throws RrdException {
        RrdBackendFactory.registerFactory(factory);
        RrdBackendFactory.setDefaultFactory(factory.getFactoryName());
    }

    public static RrdBackendFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static void setDefaultFactory(String factoryName) throws RrdException {
        if (RrdBackend.getCount() != 0L) {
            throw new RrdException("Could not change the default backend factory. This method must be called before the first RRD gets created");
        }
        defaultFactory = RrdBackendFactory.getFactory(factoryName);
    }

    protected abstract RrdBackend open(String var1, boolean var2, int var3) throws IOException;

    protected abstract boolean exists(String var1) throws IOException;

    public abstract String getFactoryName();

    static {
        try {
            RrdFileBackendFactory fileFactory = new RrdFileBackendFactory();
            RrdBackendFactory.registerFactory(fileFactory);
            RrdMemoryBackendFactory memoryFactory = new RrdMemoryBackendFactory();
            RrdBackendFactory.registerFactory(memoryFactory);
            RrdNioBackendFactory nioFactory = new RrdNioBackendFactory();
            RrdBackendFactory.registerFactory(nioFactory);
            defaultFactory = nioFactory;
        }
        catch (RrdException e) {
            throw new RuntimeException("FATAL: Cannot register RRD backend factories: " + e);
        }
    }
}

