/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

class ChartGraphics {
    private Graphics2D g;
    private int width;
    private int height;
    private long xStart;
    private long xEnd;
    private double yStart;
    private double yEnd;
    private double widthDelta = 1.0;
    private double heightDelta = 3.0;

    ChartGraphics(Graphics2D graphics) {
        this.g = graphics;
    }

    void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, -y1, x2, -y2);
    }

    void fillRect(int x1, int y1, int x2, int y2) {
        this.g.fillRect(x1, -y2, x2 - x1, -(y2 - y1));
    }

    void setColor(Color c) {
        this.g.setColor(c);
    }

    void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
    }

    void setXRange(long start, long end) {
        this.xStart = start;
        this.xEnd = end;
        this.widthDelta = this.xEnd != this.xStart ? (double)this.width * 1.0 / ((double)(this.xEnd - this.xStart) * 1.0) : 1.0;
    }

    void setYRange(double lower, double upper) {
        this.yStart = lower;
        this.yEnd = upper;
        this.heightDelta = this.yEnd != this.yStart ? (double)this.height * 1.0 / ((this.yEnd - this.yStart) * 1.0) : 1.0;
        this.yStart = this.yStart < 0.0 ? 0.0 : Math.abs(this.yStart);
    }

    int getX(long timestamp) {
        return (int)((double)(timestamp - this.xStart) * this.widthDelta);
    }

    int getY(double value) {
        if (Double.isNaN(value)) {
            return Integer.MIN_VALUE;
        }
        return (int)((value - this.yStart) * this.heightDelta);
    }

    double getInverseY(int value) {
        if (value == Integer.MIN_VALUE) {
            return Double.NaN;
        }
        return (double)value * 1.0 / this.heightDelta + this.yStart;
    }

    void setStroke(Stroke s) {
        this.g.setStroke(s);
    }

    int getMinX() {
        return 0;
    }

    int getMaxX() {
        return 0 + this.width;
    }

    int getMinY() {
        return 0;
    }

    int getMaxY() {
        return 0 + this.height;
    }

    Graphics2D getGraphics() {
        return this.g;
    }
}

