/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.IcqType;
import net.kano.joscar.snaccmd.icq.MetaAffiliationsInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaBasicInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaEmailInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaHomepageCategoryInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaInterestsInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaMoreInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaNotesInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaShortInfoCmd;
import net.kano.joscar.snaccmd.icq.MetaWorkInfoCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgDoneCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientIcqCmdFactory
implements SnacCmdFactory {
    private static final List<CmdType> SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(new CmdType(21, 3)));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 21) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 3) {
            IcqType type = AbstractIcqCmd.readIcqType(packet);
            if (type.equals(AbstractIcqCmd.CMD_META_SHORT_INFO_CMD)) {
                return new MetaShortInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_BASIC_INFO_CMD)) {
                return new MetaBasicInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_WORK_INFO_CMD)) {
                return new MetaWorkInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_MORE_INFO_CMD)) {
                return new MetaMoreInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_NOTES_INFO_CMD)) {
                return new MetaNotesInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_EMAIL_INFO_CMD)) {
                return new MetaEmailInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_INTERESTS_INFO_CMD)) {
                return new MetaInterestsInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_AFFILIATIONS_INFO_CMD)) {
                return new MetaAffiliationsInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_HOMEPAGE_CATEGORY_INFO_CMD)) {
                return new MetaHomepageCategoryInfoCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_OFFLINE_MSG)) {
                return new OfflineMsgIcqCmd(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_OFFLINE_MSG_DONE)) {
                return new OfflineMsgDoneCmd(packet);
            }
        }
        return null;
    }
}

