/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.auth;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.regex.Pattern;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.auth.AuthCommand;
import net.kano.joscar.snaccmd.auth.ClientVersionInfo;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class AuthRequest
extends AuthCommand {
    private static final int TYPE_SN = 1;
    private static final int TYPE_COUNTRY = 14;
    private static final int TYPE_LANG = 15;
    private static final int TYPE_ENCPASS = 37;
    private static final int TYPE_XORPASS = 2;
    private static final int TYPE_HASHEDPASS = 76;
    private static final String AIMSM_STRING = "AOL Instant Messenger (SM)";
    private static final byte[] AIMSM_BYTES = BinaryTools.getAsciiBytes((String)"AOL Instant Messenger (SM)");
    private static final Pattern PATTERN_NUMBER = Pattern.compile("^\\d+$");
    private final String sn;
    private final ClientVersionInfo version;
    private final Locale locale;
    private final ByteBlock encryptedPass;
    private final boolean hashedPass;
    private final boolean xorPass;

    protected AuthRequest(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ImmutableTlvChain chain = TlvTools.readChain(packet.getData());
        this.sn = chain.getString(1);
        if (chain.hasTlv(37)) {
            this.encryptedPass = chain.getLastTlv(37).getData();
            this.xorPass = false;
        } else if (chain.hasTlv(2)) {
            this.encryptedPass = chain.getLastTlv(2).getData();
            this.xorPass = true;
        } else {
            this.encryptedPass = null;
            this.xorPass = false;
        }
        this.version = ClientVersionInfo.readClientVersionInfo(chain);
        String language = chain.getString(15);
        String country = chain.getString(14);
        this.locale = language != null && country != null ? new Locale(language, country) : null;
        this.hashedPass = chain.hasTlv(76);
    }

    public AuthRequest(String sn, String pass, ClientVersionInfo version, ByteBlock key) {
        this(sn, pass, version, Locale.getDefault(), key);
    }

    public AuthRequest(String sn, String pass, ClientVersionInfo version, Locale locale, ByteBlock key) {
        this(sn, pass, version, locale, key, AuthRequest.isIcqNumber(sn));
    }

    public AuthRequest(String sn, String pass, ClientVersionInfo version, Locale locale, ByteBlock key, boolean xorPassword) {
        super(2);
        this.sn = sn;
        this.version = version;
        this.locale = locale;
        if (xorPassword) {
            this.hashedPass = false;
            this.encryptedPass = ByteBlock.wrap((byte[])this.encryptICQPassword(pass));
            this.xorPass = true;
        } else {
            this.hashedPass = true;
            this.encryptedPass = ByteBlock.wrap((byte[])this.encryptPassword(pass, key, true));
            this.xorPass = false;
        }
    }

    private static boolean isIcqNumber(String sn) {
        return PATTERN_NUMBER.matcher(sn).matches();
    }

    private byte[] encryptPassword(String pass, ByteBlock key, boolean hashedPass) {
        byte[] passBytes = BinaryTools.getAsciiBytes((String)pass);
        if (hashedPass) {
            MessageDigest digest = this.createMd5Hasher();
            passBytes = digest.digest(passBytes);
            return this.getPassHash(digest, key, ByteBlock.wrap((byte[])passBytes));
        }
        return this.getPassHash(key, ByteBlock.wrap((byte[])passBytes));
    }

    private byte[] encryptICQPassword(String pass) {
        char[] charPass = new char[pass.length()];
        byte[] bytePassword = pass.getBytes();
        byte[] xorValues = new byte[]{-13, 38, -127, -60, 57, -122, -37, -110};
        for (int i = 0; i < bytePassword.length; ++i) {
            int j = i % xorValues.length;
            charPass[i] = (char)((char)bytePassword[i] ^ (char)xorValues[j]);
        }
        return new String(charPass).getBytes();
    }

    private MessageDigest createMd5Hasher() {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException impossible) {
            throw new IllegalStateException(impossible);
        }
        return digest;
    }

    private byte[] getPassHash(ByteBlock key, ByteBlock passBytes) {
        return this.getPassHash(this.createMd5Hasher(), key, passBytes);
    }

    private byte[] getPassHash(MessageDigest md5, ByteBlock key, ByteBlock passBytes) {
        md5.update(key.toByteArray());
        md5.update(passBytes.toByteArray());
        md5.update(AIMSM_BYTES);
        return md5.digest();
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final ClientVersionInfo getVersionInfo() {
        return this.version;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final ByteBlock getEncryptedPass() {
        return this.encryptedPass;
    }

    public final boolean isPassHashed() {
        return this.hashedPass;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.xorPass) {
            out.write(ByteBlock.createFromUnsigned((int[])new int[]{0, 0, 0, 1}).toByteArray());
        }
        if (this.sn != null) {
            Tlv.getStringInstance(1, this.sn).write(out);
        }
        if (this.encryptedPass != null) {
            if (this.xorPass) {
                new Tlv(2, (Writable)this.encryptedPass).write(out);
            } else {
                new Tlv(37, (Writable)this.encryptedPass).write(out);
            }
        }
        if (this.hashedPass) {
            new Tlv(76).write(out);
        }
        if (this.version != null) {
            this.version.write(out);
        }
        if (this.locale != null) {
            String country;
            String language = this.locale.getLanguage();
            if (!language.equals("")) {
                Tlv.getStringInstance(15, language).write(out);
            }
            if (!(country = this.locale.getCountry()).equals("")) {
                Tlv.getStringInstance(14, country).write(out);
            }
        }
        if (!this.xorPass) {
            new Tlv(74, (Writable)ByteBlock.wrap((byte[])new byte[]{1})).write(out);
        }
    }

    public String toString() {
        return "AuthRequest: sn='" + this.sn + "'" + ", version='" + this.version + "'" + ", locale=" + this.locale;
    }
}

