/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Instance;
import com.hazelcast.core.InstanceDestroyedException;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.CountDownLatchProxy;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.impl.base.FactoryAwareNamedProxy;
import com.hazelcast.impl.monitor.CountDownLatchOperationsCounter;
import com.hazelcast.impl.monitor.LocalCountDownLatchStatsImpl;
import com.hazelcast.monitor.LocalCountDownLatchStats;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.concurrent.TimeUnit;

public class CountDownLatchProxyImpl
extends FactoryAwareNamedProxy
implements CountDownLatchProxy {
    private transient CountDownLatchProxy base = null;
    Data nameAsData = null;

    public CountDownLatchProxyImpl(String name, FactoryImpl factory) {
        this.set(name, factory);
        this.base = new CountDownLatchProxyReal();
    }

    public void set(String name, FactoryImpl factory) {
        this.setName(name);
        this.setHazelcastInstance(factory);
    }

    public Instance.InstanceType getInstanceType() {
        this.ensure();
        return this.base.getInstanceType();
    }

    public void destroy() {
        this.ensure();
        this.base.destroy();
    }

    public Object getId() {
        this.ensure();
        return this.base.getId();
    }

    public String getName() {
        this.ensure();
        return this.base.getName();
    }

    public String getLongName() {
        return this.name;
    }

    public String toString() {
        return "CountDownLatch [" + this.getName() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountDownLatchProxyImpl that = (CountDownLatchProxyImpl)o;
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        int result = this.base != null ? this.base.hashCode() : 0;
        result = 31 * result + (this.nameAsData != null ? this.nameAsData.hashCode() : 0);
        return result;
    }

    public void await() throws InstanceDestroyedException, MemberLeftException, InterruptedException {
        this.ensure();
        this.base.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException, InterruptedException {
        this.ensure();
        return this.base.await(timeout, unit);
    }

    public void countDown() {
        this.ensure();
        this.base.countDown();
    }

    public int getCount() {
        this.ensure();
        return this.base.getCount();
    }

    public Member getOwner() {
        this.ensure();
        return this.base.getOwner();
    }

    public boolean hasCount() {
        this.ensure();
        return this.base.hasCount();
    }

    public boolean setCount(int count) {
        this.ensure();
        return this.base.setCount(count);
    }

    public boolean setCount(int count, Address ownerAddress) {
        this.ensure();
        return this.base.setCount(count, ownerAddress);
    }

    public LocalCountDownLatchStats getLocalCountDownLatchStats() {
        this.ensure();
        return this.base.getLocalCountDownLatchStats();
    }

    public CountDownLatchOperationsCounter getCountDownLatchOperationsCounter() {
        this.ensure();
        return this.base.getCountDownLatchOperationsCounter();
    }

    private Data getNameAsData() {
        if (this.nameAsData == null) {
            this.nameAsData = IOUtil.toData(this.name);
        }
        return this.nameAsData;
    }

    private void ensure() {
        this.factory.initialChecks();
        if (this.base == null) {
            this.base = (CountDownLatchProxy)this.factory.getOrCreateProxyByName(this.name);
        }
    }

    private class CountDownLatchProxyReal
    implements CountDownLatchProxy {
        CountDownLatchOperationsCounter operationsCounter = new CountDownLatchOperationsCounter();

        public String getName() {
            return CountDownLatchProxyImpl.this.name.substring("d:".length());
        }

        public String getLongName() {
            return CountDownLatchProxyImpl.this.name;
        }

        public Object getId() {
            return CountDownLatchProxyImpl.this.name;
        }

        public void await() throws InstanceDestroyedException, MemberLeftException, InterruptedException {
            this.await(-1L, TimeUnit.MILLISECONDS);
        }

        public boolean await(long timeout, TimeUnit unit) throws InstanceDestroyedException, MemberLeftException, InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return this.newMCountDownLatch().await(CountDownLatchProxyImpl.this.getNameAsData(), timeout, unit);
        }

        public void countDown() {
            this.newMCountDownLatch().countDown(CountDownLatchProxyImpl.this.getNameAsData());
        }

        public void destroy() {
            this.newMCountDownLatch().destroy(CountDownLatchProxyImpl.this.getNameAsData());
            CountDownLatchProxyImpl.this.factory.destroyInstanceClusterWide(CountDownLatchProxyImpl.this.name, null);
        }

        public int getCount() {
            return this.newMCountDownLatch().getCount(CountDownLatchProxyImpl.this.getNameAsData());
        }

        public Member getOwner() {
            Address owner = this.newMCountDownLatch().getOwnerAddress(CountDownLatchProxyImpl.this.getNameAsData());
            Address local = ((CountDownLatchProxyImpl)CountDownLatchProxyImpl.this).factory.node.baseVariables.thisAddress;
            return owner != null ? new MemberImpl(owner, local.equals(owner)) : null;
        }

        public boolean hasCount() {
            return this.newMCountDownLatch().getCount(CountDownLatchProxyImpl.this.getNameAsData()) > 0;
        }

        public boolean setCount(int count) {
            return this.setCount(count, ((CountDownLatchProxyImpl)CountDownLatchProxyImpl.this).factory.node.getThisAddress());
        }

        public boolean setCount(int count, Address ownerAddress) {
            return this.newMCountDownLatch().setCount(CountDownLatchProxyImpl.this.getNameAsData(), count, ownerAddress);
        }

        public Instance.InstanceType getInstanceType() {
            return Instance.InstanceType.COUNT_DOWN_LATCH;
        }

        public CountDownLatchOperationsCounter getCountDownLatchOperationsCounter() {
            return this.operationsCounter;
        }

        public LocalCountDownLatchStats getLocalCountDownLatchStats() {
            LocalCountDownLatchStatsImpl localCountDownLatchStats = new LocalCountDownLatchStatsImpl();
            localCountDownLatchStats.setOperationStats(this.operationsCounter.getPublishedStats());
            return localCountDownLatchStats;
        }

        ConcurrentMapManager.MCountDownLatch newMCountDownLatch() {
            ConcurrentMapManager.MCountDownLatch mcdl = ((CountDownLatchProxyImpl)CountDownLatchProxyImpl.this).factory.node.concurrentMapManager.new ConcurrentMapManager.MCountDownLatch();
            mcdl.setOperationsCounter(this.operationsCounter);
            return mcdl;
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        }
    }
}

