/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.FallThroughRunnable;
import com.hazelcast.impl.Joiner;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Processable;
import com.hazelcast.logging.ILogger;
import java.util.logging.Level;

public class SplitBrainHandler
implements Processable {
    private final Node node;
    private final ILogger logger;
    private volatile boolean inProgress = false;
    private final long firstRunDelayMillis;
    private final long nextRunDelayMillis;

    public SplitBrainHandler(Node node) {
        this.node = node;
        this.logger = node.getLogger(SplitBrainHandler.class.getName());
        this.firstRunDelayMillis = node.getGroupProperties().MERGE_FIRST_RUN_DELAY_SECONDS.getLong() * 1000L;
        this.nextRunDelayMillis = node.getGroupProperties().MERGE_NEXT_RUN_DELAY_SECONDS.getLong() * 1000L;
    }

    public void process() {
        if (this.node.isMaster() && this.node.joined() && this.node.isActive() && !this.inProgress && this.node.clusterManager.shouldTryMerge()) {
            this.inProgress = true;
            this.node.executorManager.executeNow(new FallThroughRunnable(){

                public void doRun() {
                    SplitBrainHandler.this.searchForOtherClusters();
                    SplitBrainHandler.this.inProgress = false;
                }
            });
        }
    }

    private void searchForOtherClusters() {
        Joiner joiner = this.node.getJoiner();
        if (joiner != null) {
            this.logger.log(Level.FINEST, "Searching for other clusters.");
            this.node.getSystemLogService().logJoin("Searching for other clusters.");
            joiner.searchForOtherClusters(this);
        }
    }

    public void restart() {
        this.node.factory.restartToMerge();
    }

    public long getFirstRunDelayMillis() {
        return this.firstRunDelayMillis;
    }

    public long getNextRunDelayMillis() {
        return this.nextRunDelayMillis;
    }
}

